﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using EffectMaker.DataModel.AnimationTable;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Attributes;
using EffectMaker.Foundation.Command;
using EffectMaker.Foundation.EventArguments;
using EffectMaker.Foundation.Input;
using EffectMaker.Foundation.Interfaces;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Utility;
using EffectMaker.UILogic.Attributes;

namespace EffectMaker.UILogic.ViewModels
{
    /// <summary>
    /// Class for the view model of the MagnetBasicParamViewModel.
    /// </summary>
    public class MagnetBasicParamViewModel : CurveEditorOwnerViewModel<MagnetParamData>, IModificationFlagOwner
    {
        /// <summary>
        /// The constructor.
        /// </summary>
        /// <param name="parent">The parent view model.</param>
        /// <param name="dataModel">The data model to encapsulate.</param>
        public MagnetBasicParamViewModel(HierarchyViewModel parent, MagnetParamData dataModel)
            : base(parent, dataModel)
        {
            this.SetDefaultSnapSetting("FieldMagnetBasic");
            this.DefaultValue = new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);
            var table = this.GetDataModelValue<AnimationTableData>("AnimationTable");
            if (table.Count == 0)
            {
                this.InitData();
            }

            // デフォルト値を更新
            this.UpdatePropertyDescriptors();

            var magnetCurverProperties = EnumerableUtility.Enumerate(
                    ViewModelBase.NameOf(() => dataModel.EnableAnimation),
                    ViewModelBase.NameOf(() => dataModel.AnimationTable),
                    ViewModelBase.NameOf(() => dataModel.LoopMode),
                    ViewModelBase.NameOf(() => dataModel.LoopEnd),
                    ViewModelBase.NameOf(() => dataModel.Randomize),
                    ViewModelBase.NameOf(() => dataModel.MagnetPower));

            var enableAxisesProperties = EnumerableUtility.Enumerate(
                    ViewModelBase.NameOf(() => dataModel.EnableAxisX),
                    ViewModelBase.NameOf(() => dataModel.EnableAxisY),
                    ViewModelBase.NameOf(() => dataModel.EnableAxisZ));

            // Always create the modification flag view model IN THE END of the constructor
            // to prevent any initialization triggers the modification events.
            var mmfvm = new MultipleModificationFlagsViewModel(this);
            mmfvm.SetPropertyDictionary("MagnetCurve", magnetCurverProperties);
            mmfvm.SetPropertyDictionary("EnableAxises", enableAxisesProperties);
            this.ModificationFlagViewModel = mmfvm;

            // データ変更フラグをクリア。
            this.ModificationFlagViewModel.ClearModificationFlags();
            this.ModificationFlagViewModel.ClearChildModificationFlags();
        }

        /// <summary>
        /// Get the view model that holds the modification flags of
        /// this view model's properties.
        /// </summary>
        public ModificationFlagViewModel ModificationFlagViewModel { get; private set; }
    }
}
