﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using EffectMaker.BusinessLogic.EffectCombinerEditor;
using EffectMaker.BusinessLogic.IO;
using EffectMaker.BusinessLogic.Options;
using EffectMaker.DataModel.AnimationTable;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.DataModelLogic.Utilities;
using EffectMaker.Foundation.Attributes;
using EffectMaker.Foundation.Editting;
using EffectMaker.Foundation.Extensions;
using EffectMaker.Foundation.Input;
using EffectMaker.Foundation.Interfaces;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Utility;
using EffectMaker.UILogic.Attributes;

namespace EffectMaker.UILogic.ViewModels
{
    public class EmitterCombinerEditorAnimationCurveViewModel : CurveEditorOwnerViewModel<EmitterCombinerEditorAnimationCurveData>, IModificationFlagOwner
    {
        /// <summary>
        /// 変更の対象に含めないプロパティ名のリストです.
        /// </summary>
        private readonly string[] ignorePropertyNames = new string[]
        {
            "GroupVisibility",
        };

        /// <summary>
        /// グループの表示状態.
        /// </summary>
        private bool groupVisibility = false;

        /// <summary>
        /// The constructor.
        /// </summary>
        /// <param name="parent">The parent view model.</param>
        /// <param name="dataModel">The data model to encapsulate.</param>
        public EmitterCombinerEditorAnimationCurveViewModel(
            HierarchyViewModel parent,
            EmitterCombinerEditorAnimationCurveData dataModel)
            : base(parent, dataModel)
        {
            this.SetDefaultSnapSetting("EmitterCombinerEditor");
            this.DefaultValue = new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);
            var table = this.GetDataModelValue<AnimationTableData>("AnimationTable");
            if (table.Count == 0)
            {
                this.InitData();
            }

            // デフォルト値を更新
            this.UpdatePropertyDescriptors();

            var mmfvm = new MultipleModificationFlagsViewModel(this);
            var animeParams = EnumerableUtility.Enumerate(
                ViewModelBase.NameOf(() => dataModel.AnimationTable),
                ViewModelBase.NameOf(() => dataModel.LoopMode),
                ViewModelBase.NameOf(() => dataModel.LoopEnd),
                ViewModelBase.NameOf(() => dataModel.Randomize));
            mmfvm.SetPropertyDictionary("AnimeParams", animeParams);

            // Always create the modification flag view model IN THE END of the constructor
            // to prevent any initialization triggers the modification events.
            this.ModificationFlagViewModel = mmfvm;
            this.ModificationFlagViewModel.AddIgnoreProperties(this.ignorePropertyNames);

            // データ変更フラグをクリア。
            this.ModificationFlagViewModel.ClearModificationFlags();
            this.ModificationFlagViewModel.ClearChildModificationFlags();
        }

        /// <summary>
        /// グループの表示状態.
        /// </summary>
        public bool GroupVisibility
        {
            get { return this.groupVisibility; }
            set { this.SetValue(ref this.groupVisibility, value); }
        }

        /// <summary>
        /// Get the view model that holds the modification flags of
        /// this view model's properties.
        /// </summary>
        public ModificationFlagViewModel ModificationFlagViewModel { get; private set; }
    }
}
