﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using EffectMaker.DataModel.AnimationTable;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Attributes;
using EffectMaker.Foundation.Command;
using EffectMaker.Foundation.EventArguments;
using EffectMaker.Foundation.Input;
using EffectMaker.Foundation.Interfaces;

namespace EffectMaker.UILogic.ViewModels
{
    /// <summary>
    /// ループ情報
    /// </summary>
    public class EmitterAnimationLoopViewModel : PropertyGroupViewModel<EmitterColorSettingsAnimationData>, IModificationFlagOwner, IModificationPropertyOwner
    {
        /// <summary>
        /// The constructor.
        /// </summary>
        /// <param name="parent">The parent view model.</param>
        /// <param name="dataModel">The data model to encapsulate.</param>
        public EmitterAnimationLoopViewModel(
            HierarchyViewModel parent, EmitterColorSettingsAnimationData dataModel)
            : base(parent, dataModel)
        {
            // Always create the modification flag view model IN THE END of the constructor,
            // in case any initialization triggers the modification events.
            this.ModificationFlagViewModel = new ModificationFlagViewModel(this);
        }

        /// <summary>
        /// ループ情報に変更があるか
        /// </summary>
        public bool IsModified
        {
            get { return this.ModificationFlagViewModel.IsAnyValueModified;  }
        }

        /// <summary>
        /// ループ情報がデフォルトの状態か
        /// </summary>
        public bool IsDefault
        {
            get
            {
                bool isDefault = this.DataModel.EnableLoop == false;
                isDefault &= this.DataModel.LoopFrame == 100;
                isDefault &= this.DataModel.EnableStartRandom == false;

                return isDefault;
            }
        }

        /// <summary>
        /// Get the view model that holds the modification flags of
        /// this view model's properties.
        /// </summary>
        public ModificationFlagViewModel ModificationFlagViewModel { get; private set; }
    }
}
