﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;

namespace EffectMaker.UILogic.Attributes
{
    /// <summary>
    /// Custom attribute to use data model property, instead of view model property,
    /// as the original value.
    /// When the view model has a property, that has the same name as the property in
    /// the data model, the view model will use the value of the data model property,
    /// instead of the view model.
    /// </summary>
    [AttributeUsage(AttributeTargets.Property, AllowMultiple = false, Inherited = false)]
    public class UseDataModelOriginalValueAttribute : System.Attribute
    {
        /// <summary>
        /// Constructor.
        /// </summary>
        public UseDataModelOriginalValueAttribute()
        {
            this.DataModelPropertyName = string.Empty;
        }

        /// <summary>
        /// Constructor.
        /// </summary>
        /// <param name="dataModelPropertyName">
        /// The name of the data model property of which the value is used as the original value
        /// of the view model property.
        /// </param>
        public UseDataModelOriginalValueAttribute(string dataModelPropertyName)
        {
            this.DataModelPropertyName = dataModelPropertyName;
        }

        /// <summary>
        /// Get the name of the data model property for acquiring the original value
        /// of the view model property.
        /// Use the data model property which has the same name as the view model property
        /// if this is an empty string.
        /// </summary>
        public string DataModelPropertyName { get; private set; }
    }
}
