﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using EffectMaker.Foundation.Collections.Generic;
using EffectMaker.Foundation.Texture;

namespace EffectMaker.TextureManager.Cache
{
    /// <summary>
    /// テクスチャデータキャッシュ
    /// </summary>
    public class TextureDataCache : LruCache<string, TextureDataCache.TextureFileData>
    {
        /// <summary>
        /// デフォルトのキャッシュ容量(単位バイト）
        /// </summary>
        private const int InitialMaxCapacity = 256 * 1024 * 1024;

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public TextureDataCache()
            : base(InitialMaxCapacity, StringComparer.InvariantCultureIgnoreCase)
        {
        }

        /// <summary>
        /// 値サイズを得る
        /// </summary>
        /// <param name="value">値</param>
        /// <returns>値サイズ</returns>
        protected override int GetValueSize(TextureFileData value)
        {
            return value.Data.MemorySize;
        }

        /// <summary>
        /// テクスチャファイルデータ
        /// </summary>
        public class TextureFileData
        {
            /// <summary>
            /// データ
            /// </summary>
            public TextureData Data { get; set; }

            /// <summary>
            /// 更新日時
            /// </summary>
            public DateTime UpdateTimestamp { get; set; }
        }
    }
}
