﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using EffectMaker.Foundation.Collections.Generic;
using EffectMaker.Foundation.Model;

namespace EffectMaker.PrimitiveManager.Cache
{
    /// <summary>
    /// モデルデータキャッシュ.
    /// </summary>
    public class ModelDataCache : LruCache<string, ModelDataCache.ModelFileData>
    {
        /// <summary>
        /// キャッシュ容量(単位バイト)
        /// </summary>
        private const int MaxCapacity = 92 * 10000 * 50;    // 頂点サイズ92 ×　1万頂点 × 50個分 (※要サイズ調整).

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public ModelDataCache()
            : base(MaxCapacity, StringComparer.InvariantCultureIgnoreCase)
        {
            /* DO_NOTHING */
        }

        /// <summary>
        /// 値サイズを得る
        /// </summary>
        /// <param name="value">値</param>
        /// <returns>値サイズ</returns>
        protected override int GetValueSize(ModelFileData value)
        {
            return value.Data.MemorySize;
        }

        /// <summary>
        /// モデルファイルデータ
        /// </summary>
        public class ModelFileData
        {
            /// <summary>
            /// データ
            /// </summary>
            public ModelData Data { get; set; }

            /// <summary>
            /// 更新日時
            /// </summary>
            public DateTime UpdateTimestamp { get; set; }
        }
    }
}
