﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;
using EffectMaker.DataModelLogic.Properties;

namespace EffectMaker.DataModelLogic
{
    /// <summary>
    /// ユーザデータモデルからリソースにアクセスする手段を提供します。
    /// </summary>
    public static class ResourceAccessor
    {
        /// <summary>
        /// リソース型情報キャッシュ
        /// </summary>
        private static readonly Type TypeInfo = typeof(Resources);

        /// <summary>
        /// 文字列値キャッシュ
        /// </summary>
        private static readonly Dictionary<string, string> StringCaches = new Dictionary<string, string>();

        /// <summary>
        /// 文字列リソースを取得します。
        /// </summary>
        /// <param name="resourceName">リソース名</param>
        /// <returns>ローカライズ済みの文字列リソース</returns>
        public static string GetString(string resourceName)
        {
            if (!StringCaches.ContainsKey(resourceName))
            {
                var prop = TypeInfo.GetProperty(resourceName, BindingFlags.NonPublic | BindingFlags.Static);
                if (prop == null)
                {
                    return "<Reflection Error>";
                }

                var resStr = prop.GetValue(TypeInfo) as string;
                StringCaches.Add(resourceName, resStr);
            }

            return StringCaches[resourceName];
        }
    }
}
