﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModelLogic.BinaryData;

namespace EffectMaker.DataModelLogic.Extensions
{
    /// <summary>
    /// Extension methods for binary element instances.
    /// </summary>
    public static class BinaryElementInstanceExtensions
    {
        /// <summary>
        /// Find the nearest parent binary structure instance
        /// that the source data model is of the specified type.
        /// </summary>
        /// <typeparam name="T">The data model type.</typeparam>
        /// <param name="self">The binary element instance to start searching.</param>
        /// <returns>The matching parent binary structure or null if not found.</returns>
        public static BinaryStructInstance FindNearestParentStructByDataModel<T>(
            this IBinaryElementInstance self) where T : DataModelBase
        {
            IBinaryElementInstance curr = self;

            do
            {
                var binStruct = curr as BinaryStructInstance;
                if (binStruct != null && binStruct.DataModel is T)
                {
                    return binStruct;
                }

                curr = curr.Parent;
            }
            while (curr != null);

            return null;
        }
    }
}
