﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;

using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Specific.DataModels;

namespace EffectMaker.DataModelLogic.Events
{
    /// <summary>
    /// Event argument class for data model's property modified event.
    /// </summary>
    public class DataModelPropertyModifiedEventArgs : EventArgs
    {
        /// <summary>
        /// Constructor.
        /// </summary>
        /// <param name="dataModel">The data model.</param>
        /// <param name="propertyName">The property name.</param>
        public DataModelPropertyModifiedEventArgs(
            DataModelBase dataModel,
            string propertyName)
        {
            this.DataModel = dataModel;
            this.PropertyName = propertyName;
        }

        /// <summary>
        /// Get the data model which contains the modified property.
        /// </summary>
        public DataModelBase DataModel { get; private set; }

        /// <summary>
        /// Get the name of the modified property.
        /// </summary>
        public string PropertyName { get; private set; }
    }
}
