﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;

using EffectMaker.DataModelLogic.BinaryConverters;

using EffectMaker.Foundation.Collections;
using EffectMaker.Foundation.Log;

namespace EffectMaker.DataModelLogic.BinaryData
{
    /// <summary>
    /// Class for the input property definition for the binary fields.
    /// </summary>
    public class InputPropertyDefinition
    {
        /// <summary>
        /// Constructor.
        /// </summary>
        /// <param name="path">The path from the source data model to the property.</param>
        /// <param name="guid">The Guid of the property.</param>
        public InputPropertyDefinition(
            string path,
            Guid guid)
        {
            this.Guid = guid;
            this.Path = new PathNodeList(path);
        }

        /// <summary>
        /// Get the Guid of the property.
        /// </summary>
        public Guid Guid { get; private set; }

        /// <summary>
        /// Get the path from the source data model of the binary field to the property.
        /// </summary>
        public PathNodeList Path { get; private set; }
    }
}
