﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Reflection;

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.DataModelLogic.BinaryConverters;
using EffectMaker.DataModelLogic.BinaryData;
using EffectMaker.DataModelLogic.Utilities;

using ConverterParam = System.Collections.Generic.KeyValuePair<string, object>;

namespace EffectMaker.DataModelLogic.BinaryConversionInfo
{
    /// <summary>
    /// [AUTO GENERATED CLASS, DO NOT MODIFY]
    /// Auto-generated class for converting data model values.
    /// </summary>
    public class ModelBinaryConversionInfo : BinaryConversionInfoBase
    {
        /// <summary>A flag to prevent the static constructor being called more than once.</summary>
        private static bool isStaticConstructorCalled = false;

        /// <summary>The root binary structure definition.</summary>
        private static BinaryStructDefinition rootBinaryDefinition = null;

        /// <summary>The list of instance.</summary>
        private static Dictionary<DataModelBase, BinaryConversionInfoBase> instanceMap = null;

        /// <summary>The root binary structure instance.</summary>
        private BinaryStructInstance rootBinaryInstance = null;

        /// <summary>
        /// The constructor.
        /// </summary>
        static ModelBinaryConversionInfo()
        {
            if (isStaticConstructorCalled == true)
            {
                return;
            }

            isStaticConstructorCalled = true;

            instanceMap = new Dictionary<DataModelBase, BinaryConversionInfoBase>();

            var modelBinary = new BinaryStructDefinition(typeof(ModelData)) { HasBinaryHeader = true };

            var modelUserPageBinary = new BinaryStructDefinition(typeof(UserPageData)) { HasBinaryHeader = false };

            // Output : ModelUserPageBinary
            // Inputs : UserPages
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                modelBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(AssignDataModelConverter)),
                modelUserPageBinary,
                new InputPropertyDefinition("UserPages", new Guid("eac5f18c-8425-4d5d-84b4-fce07ba6da67"))
            );

            var modelUserDataBinary = new BinaryStructDefinition(null) { HasBinaryHeader = false };

            // Output : ModelUserDataBinary
            // Inputs : ContentsData
            BinaryConversionInfoBase.AddSelectBinaryDataFieldDefinition(
                modelUserPageBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                modelUserDataBinary,
                new InputPropertyDefinition("ContentsData", new Guid("e32b5d9a-2d76-4687-a92d-986678e751d9"))
            );


            //-----------------------------------------------------------------
            // Save the binary structure definition.
            //-----------------------------------------------------------------
            rootBinaryDefinition = modelBinary;

            //-----------------------------------------------------------------
            // Register events.
            //-----------------------------------------------------------------
            BinaryConversionInfoManager.DataModelCreated   += OnDataModelCreated;
            BinaryConversionInfoManager.DataModelDestroyed += OnDataModelDestroyed;
        }

        /// <summary>
        /// The constructor.
        /// </summary>
        /// <param name="dataModel">The data model to convert.</param>
        private ModelBinaryConversionInfo(DataModelBase dataModel)
        {
            this.rootBinaryInstance = rootBinaryDefinition.CreateInstance(null, dataModel);
            this.rootBinaryInstance.ConvertBinary();
        }

        /// <summary>
        /// Dispose.
        /// </summary>
        public override void Dispose()
        {
            // Dispose the binary structure instance.
            if (this.rootBinaryInstance != null)
            {
                this.rootBinaryInstance.Dispose();
            }
        }

        /// <summary>
        /// Handle DataModelCreated event from the manager.
        /// </summary>
        /// <param name="sender">The sender of the event, should be null.</param>
        /// <param name="dataModel">The created data model.</param>
        private static void OnDataModelCreated(object sender, DataModelBase dataModel)
        {
            if (typeof(ModelData).IsInstanceOfType(dataModel) == true)
            {
                var instance = new ModelBinaryConversionInfo(dataModel);
                instanceMap.Add(dataModel, instance);

                SendModifiedBinaryContext.BeginSession();
                SendModifiedBinaryContext.AddBinaryStructToSend(instance.rootBinaryInstance);
                SendModifiedBinaryContext.EndSession();
            }
        }

        /// <summary>
        /// Handle DataModelCreated event from the manager.
        /// </summary>
        /// <param name="sender">The sender of the event, should be null.</param>
        /// <param name="dataModel">The created data model.</param>
        private static void OnDataModelDestroyed(object sender, DataModelBase dataModel)
        {
            if (typeof(ModelData).IsInstanceOfType(dataModel) == true)
            {
                if (instanceMap.ContainsKey(dataModel))
                {
                    var instance = instanceMap[dataModel];
                    instanceMap.Remove(dataModel);
                    instance.Dispose();
                }
            }
        }

    }
}
