﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using EffectMaker.Foundation.Utility;

namespace EffectMaker.BusinessLogic.ViewerMessages
{
    /// <summary>
    /// Viewer message class that asks the viewer to remove instance for the specified asset.
    /// </summary>
    public class DeleteInstanceMessage : MessageBase
    {
        /// <summary>The type of the asset the binary data is.</summary>
        private AssetTypes assetType;

        /// <summary>The Guid of the asset.</summary>
        private Guid assetGuid;

        /// <summary>The Guid of the previe.</summary>
        private Guid previewGuid;

        /// <summary>
        /// Constructor.
        /// </summary>
        /// <param name="assetType">The type of the asset.</param>
        /// <param name="assetGuid">The Guid of the asset.</param>
        /// <param name="previewGuid">The Guid of the preview.</param>
        public DeleteInstanceMessage(
            AssetTypes assetType,
            Guid assetGuid,
            Guid previewGuid) : base()
        {
            this.assetType = assetType;
            this.assetGuid = assetGuid;
            this.previewGuid = previewGuid;
        }

        /// <summary>
        /// Get the type of the message.
        /// </summary>
        public override MessageTypes MessageType
        {
            get { return MessageTypes.DeleteInstance; }
        }

        /// <summary>
        /// Get the size of the message.
        /// </summary>
        public override int MessageSize
        {
            get
            {
                // (sizeof(assetType) = 4)
                // + (sizeof(assetGuid) = 16)
                // + (sizeof(previewGuid) = 16) = 36
                return 36;
            }
        }

        /// <summary>
        /// Write message data to a stream with the given writer.
        /// </summary>
        /// <param name="writer">The message writer.</param>
        /// <returns>True on success.</returns>
        protected override bool WriteMessage(MessageWriter writer)
        {
            if (base.WriteMessage(writer) == false)
            {
                return false;
            }

            writer.Write(BinaryConversionUtility.ForProtocol.Convert((int)this.assetType));
            writer.Write(BinaryConversionUtility.ForProtocol.Convert(this.assetGuid));
            writer.Write(BinaryConversionUtility.ForProtocol.Convert(this.previewGuid));

            return true;
        }
    }
}
