﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Reflection;

namespace EffectMaker.BusinessLogic.UserData
{
    /// <summary>
    /// The data class stores information about a loaded user data.
    /// </summary>
    public class UserDataInfo
    {
        /// <summary>
        /// Get or set the name for identifying the user data.
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// Get or set the owner type of the user data.
        /// </summary>
        public Type OwnerType { get; set; }

        /// <summary>
        /// Get or set the data model source file path.
        /// </summary>
        public string DataModelSourceFilePath { get; set; }

        /// <summary>
        /// Get or set the binary conversion info source file path.
        /// </summary>
        public string BinaryConversionInfoPath { get; set; }

        /// <summary>
        /// Get or set the XAML file path.
        /// </summary>
        public string XamlFilePath { get; set; }

        /// <summary>
        /// Xamlのコードを取得または設定します。
        /// </summary>
        public string XamlCode { get; set; }

        /// <summary>
        /// XPath テーブルを取得または設定します。
        /// </summary>
        public string XPathTable { get; set; }

        /// <summary>
        /// Get or set the compiled assembly of the user data.
        /// </summary>
        public Assembly Assembly { get; set; }

        /// <summary>
        /// Get or set the data model class type.
        /// </summary>
        public Type DataModelType { get; set; }

        /// <summary>
        /// Get or set the binary conversion info class type.
        /// </summary>
        public Type BinaryConversionInfoType { get; set; }

        /// <summary>
        /// Get or set all the exported user data types from the assembly.
        /// </summary>
        public List<Type> ExportedUserDataTypes { get; set; }
    }
}
