﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Threading;
using EffectMaker.Foundation.Log;

namespace EffectMaker.BusinessLogic.Synchronization
{
    /// <summary>
    /// グローバル同期セクションです。
    /// この区間では、異なる exe ファイルを含めた全ての EffectMaker のプロセスで同期が行われます。
    /// </summary>
    public class GlobalSyncSection : IDisposable
    {
        /// <summary>
        /// ミューテックスです。
        /// </summary>
        private Mutex mutex;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public GlobalSyncSection()
        {
            try
            {
                this.mutex = new Mutex(false, "NW_EffectMaker_FE2");
                this.mutex.WaitOne();
            }
            catch
            {
            }
        }

        /// <summary>
        /// ファイナライザです。
        /// </summary>
        ~GlobalSyncSection()
        {
            this.InnerDispose(false);
        }

        /// <summary>
        /// Dispose処理を行います。
        /// </summary>
        public virtual void Dispose()
        {
            this.InnerDispose(true);

            GC.SuppressFinalize(this);
        }

        /// <summary>
        /// Dispose処理の本体です。
        /// </summary>
        /// <param name="disposing">Disposeメソッドからの呼び出しか</param>
        private void InnerDispose(bool disposing)
        {
            System.Diagnostics.Debug.Assert(disposing == true, "必ず using ブロックで使用する");

            if (this.mutex != null)
            {
                try
                {
                    this.mutex.ReleaseMutex();
                }
                catch (Exception e)
                {
                    Logger.LogException("Console", LogLevels.Warning, e);
                }

                this.mutex = null;
            }
        }
    }
}
