﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;

using EffectMaker.BusinessLogic.IO;
using EffectMaker.BusinessLogic.Options;
using EffectMaker.BusinessLogic.Properties;
using EffectMaker.Foundation.Log;

namespace EffectMaker.BusinessLogic.EffectCombinerEditor
{
    /// <summary>
    /// Manager class for the communications between EffectCombinerEditor and EffectMaker.
    /// </summary>
    public class EffectCombinerCommunicationManager
    {
        /// <summary>
        /// 初期化したかどうか
        /// </summary>
        private static bool _initialized = false;

        /// <summary>
        /// コンバイナエディタと通信するインスタンス
        /// </summary>
        private static IEffectCombinerCommunicationBridge _communicationBridge = null;

        /// <summary>
        /// コンバイナエディタと通信するインスタンスのプロパティ
        /// </summary>
        public static IEffectCombinerCommunicationBridge CommunicationBridge
        {
            get
            {
                // 初回呼び出し時のみ、dllファイルからクラスをロードする.
                if (_initialized == false)
                {
                    string libraryPath = Path.Combine(IOConstants.CoreModulesPath, "EffectMaker.EffectCombinerBridge.dll");
                    Assembly asm;

                    try
                    {
                        asm = Assembly.LoadFrom(libraryPath);
                    }
                    catch (FileNotFoundException)
                    {
                        // dllファイルがない場合は、コンバイナエディタと通信しない.
                        _communicationBridge = null;
                        asm = null;
                    }

                    // dllファイルからのロードに成功した場合のみ、インスタンスを生成する.
                    if (asm != null)
                    {
                        foreach (var t in asm.GetTypes())
                        {
                            // インタフェースだった場合は無視.
                            if (t.IsInterface) continue;

                            try
                            {
                                _communicationBridge = Activator.CreateInstance(t) as IEffectCombinerCommunicationBridge;
                            }
                            catch (Exception)
                            {
                                _communicationBridge = null;
                                continue;
                            }

                            if (_communicationBridge != null)
                            {
                                break;
                            }
                        }
                    }

                    // 初期化済みマークを付ける
                    _initialized = true;
                }

                return _communicationBridge;
            }
        }
    }
}
