﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EffectMaker.BusinessLogic.CurveEditorParameters
{
    /// <summary>
    /// カーブエディタウィンドウに渡すパラメータを集約したクラス
    /// </summary>
    public class EmitterAnimationEditorParameter
    {
        /// <summary>
        /// データコンテキスト.
        /// </summary>
        public object DataContext { get; set; }

        /// <summary>
        /// 基準距離1をいくつの値として正規化するか.
        /// </summary>
        public float NormalizeAt { get; set; }

        /// <summary>
        /// ラベルに表示する小数点以下桁数.
        /// </summary>
        public int LabelDigit { get; set; }

        /// <summary>
        /// 縦軸値の接頭辞
        /// </summary>
        public string LabelPrefix { get; set; }

        /// <summary>
        /// 最大値.
        /// </summary>
        public float MaxLimit { get; set; }

        /// <summary>
        /// 最小値.
        /// </summary>
        public float MinLimit { get; set; }

        /// <summary>
        /// 初期キー値.
        /// </summary>
        public float DefaultValue { get; set; }

        /// <summary>
        /// 0固定機能の初期状態
        /// -1:無効(非表示),0:上辺,1:中央,2:下辺,3:無し
        /// </summary>
        public int DefaultZeroPin { get; set; }

        /// <summary>
        /// 整数値のみ指定
        /// </summary>
        public bool IntegerOnly { get; set; }

        /// <summary>
        /// チャンネル名のリスト(個数でチャンネル数指定).
        /// </summary>
        public List<string> Channels { get; set; }

        /// <summary>
        /// アニメーション名.
        /// </summary>
        public string AnimationName { get; set; }
    }
}
