﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace EffectMaker.Foundation.Texture
{
    /// <summary>
    /// The texture dimension types.
    /// </summary>
    public enum TextureDimensionTypes : uint
    {
        /// <summary>1D texture.</summary>
        Texture1D,

        /// <summary>2D texture.</summary>
        Texture2D,

        /// <summary>3D texture.</summary>
        Texture3D,

        /// <summary>Cube map.</summary>
        TextureCube,

        /// <summary>1D texture array.</summary>
        Texture1DArray,

        /// <summary>2D texture array.</summary>
        Texture2DArray,

        /// <summary>Cube map array.</summary>
        TextureCubeArray,
    }
}
