﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
//------------------------------------------------------------------------------
// <auto-generated>
//  単純な列挙体定義のみのため、StyleCopチェックを無効にする
// </auto-generated>
//------------------------------------------------------------------------------

namespace EffectMaker.Foundation.Texture
{
    /// <summary>
    /// ピクセルフォーマットです。
    /// </summary>
    public enum PixelFormats
    {
        Unorm_8,
        Uint_8,
        Snorm_8,
        Sint_8,
        Unorm_4_4,
        Unorm_16,
        Uint_16,
        Snorm_16,
        Sint_16,
        Float_16,
        Unorm_8_8,
        Uint_8_8,
        Snorm_8_8,
        Sint_8_8,
        Unorm_5_6_5,
        Unorm_5_5_5_1,
        Unorm_4_4_4_4,
        Unorm_1_5_5_5,
        Uint_32,
        Sint_32,
        Float_32,
        Unorm_16_16,
        Uint_16_16,
        Snorm_16_16,
        Sint_16_16,
        Float_16_16,
        Float_11_11_10,
        Unorm_10_10_10_2,
        Uint_10_10_10_2,
        Unorm_8_8_8_8,
        Uint_8_8_8_8,
        Snorm_8_8_8_8,
        Sint_8_8_8_8,
        Srgb_8_8_8_8,
        Unorm_2_10_10_10,
        Uint_2_10_10_10,
        Uint_32_32,
        Sint_32_32,
        Float_32_32,
        Unorm_16_16_16_16,
        Uint_16_16_16_16,
        Snorm_16_16_16_16,
        Sint_16_16_16_16,
        Float_16_16_16_16,
        Uint_32_32_32_32,
        Sint_32_32_32_32,
        Float_32_32_32_32,
        Unorm_bc1,
        Srgb_bc1,
        Unorm_bc2,
        Srgb_bc2,
        Unorm_bc3,
        Srgb_bc3,
        Unorm_bc4,
        Snorm_bc4,
        Unorm_bc5,
        Snorm_bc5,
        Ufloat_bc6,
        Float_bc6,
        Unorm_bc7,
        Srgb_bc7,
        Unorm_pvrtc1_2bpp,
        Srgb_pvrtc1_2bpp,
        Unorm_pvrtc1_4bpp,
        Srgb_pvrtc1_4bpp,
        Unorm_pvrtc1_alpha_2bpp,
        Srgb_pvrtc1_alpha_2bpp,
        Unorm_pvrtc1_alpha_4bpp,
        Srgb_pvrtc1_alpha_4bpp,
        Unorm_pvrtc2_alpha_2bpp,
        Srgb_pvrtc2_alpha_2bpp,
        Unorm_pvrtc2_alpha_4bpp,
        Srgb_pvrtc2_alpha_4bpp,
        Unorm_astc_4x4,
        Srgb_astc_4x4,
        Unorm_astc_5x4,
        Srgb_astc_5x4,
        Unorm_astc_5x5,
        Srgb_astc_5x5,
        Unorm_astc_6x5,
        Srgb_astc_6x5,
        Unorm_astc_6x6,
        Srgb_astc_6x6,
        Unorm_astc_8x5,
        Srgb_astc_8x5,
        Unorm_astc_8x6,
        Srgb_astc_8x6,
        Unorm_astc_8x8,
        Srgb_astc_8x8,
        Unorm_astc_10x5,
        Srgb_astc_10x5,
        Unorm_astc_10x6,
        Srgb_astc_10x6,
        Unorm_astc_10x8,
        Srgb_astc_10x8,
        Unorm_astc_10x10,
        Srgb_astc_10x10,
        Unorm_astc_12x10,
        Srgb_astc_12x10,
        Unorm_astc_12x12,
        Srgb_astc_12x12,
    }

    /// <summary>
    /// PixelFormat 列挙体の拡張関数です。
    /// </summary>
    public static class PixelFormatExtension
    {
        /// <summary>
        /// PVR 系のフォーマットかどうか取得します。
        /// </summary>
        /// <param name="format">ピクセルフォーマット</param>
        /// <returns>PVR 系のフォーマットのときtrue、それ以外のときfalseを返します。</returns>
        public static bool IsPvr(this PixelFormats format)
        {
            return (format == PixelFormats.Unorm_pvrtc1_2bpp) ||
                   (format == PixelFormats.Unorm_pvrtc1_4bpp) ||
                   (format == PixelFormats.Unorm_pvrtc1_alpha_2bpp) ||
                   (format == PixelFormats.Unorm_pvrtc1_alpha_4bpp) ||
                   (format == PixelFormats.Unorm_pvrtc2_alpha_2bpp) ||
                   (format == PixelFormats.Unorm_pvrtc2_alpha_4bpp) ||
                   (format == PixelFormats.Srgb_pvrtc1_2bpp) ||
                   (format == PixelFormats.Srgb_pvrtc1_4bpp) ||
                   (format == PixelFormats.Srgb_pvrtc1_alpha_2bpp) ||
                   (format == PixelFormats.Srgb_pvrtc1_alpha_4bpp) ||
                   (format == PixelFormats.Srgb_pvrtc2_alpha_2bpp) ||
                   (format == PixelFormats.Srgb_pvrtc2_alpha_4bpp);
        }

        /// <summary>
        /// 圧縮フォーマットかどうか取得します。
        /// </summary>
        /// <param name="format">ピクセルフォーマット</param>
        /// <returns>圧縮フォーマットのときtrue、それ以外のときfalseを返します。</returns>
        public static bool IsCompressed(this PixelFormats format)
        {
            return (format == PixelFormats.Unorm_bc1) ||
                   (format == PixelFormats.Srgb_bc1) ||
                   (format == PixelFormats.Unorm_bc2) ||
                   (format == PixelFormats.Srgb_bc2) ||
                   (format == PixelFormats.Unorm_bc3) ||
                   (format == PixelFormats.Srgb_bc3) ||
                   (format == PixelFormats.Unorm_bc4) ||
                   (format == PixelFormats.Snorm_bc4) ||
                   (format == PixelFormats.Unorm_bc5) ||
                   (format == PixelFormats.Snorm_bc5) ||
                   (format == PixelFormats.Unorm_bc7) ||
                   (format == PixelFormats.Srgb_bc7);
        }

        /// <summary>
        /// SRGB フォーマットかどうか取得します。
        /// </summary>
        /// <param name="format">ピクセルフォーマット</param>
        /// <returns>SRGB フォーマットのときtrue、それ以外のときfalseを返します。</returns>
        public static bool IsSrgb(this PixelFormats format)
        {
            return (format == PixelFormats.Srgb_8_8_8_8) ||
                   (format == PixelFormats.Srgb_bc1) ||
                   (format == PixelFormats.Srgb_bc2) ||
                   (format == PixelFormats.Srgb_bc3) ||
                   (format == PixelFormats.Srgb_bc7);
        }

        /// <summary>
        /// Snorm フォーマットかどうか取得します。
        /// </summary>
        /// <param name="format">ピクセルフォーマット</param>
        /// <returns>Snorm フォーマットのときtrue、それ以外のときfalseを返します。</returns>
        public static bool IsSnorm(this PixelFormats format)
        {
            return (format == PixelFormats.Snorm_16)          ||
                   (format == PixelFormats.Snorm_16_16)       ||
                   (format == PixelFormats.Snorm_16_16_16_16) ||
                   (format == PixelFormats.Snorm_8)           ||
                   (format == PixelFormats.Snorm_8_8)         ||
                   (format == PixelFormats.Snorm_8_8_8_8)     ||
                   (format == PixelFormats.Snorm_bc4)         ||
                   (format == PixelFormats.Snorm_bc5);
        }

        /// <summary>
        /// アルファチャンネルを持つかどうか取得します。
        /// </summary>
        /// <param name="format">ピクセルフォーマット</param>
        /// <returns>アルファチャンネルを持つときtrue、それ以外のときfalseを返します。</returns>
        public static bool HasAlpha(this PixelFormats format)
        {
            return (format == PixelFormats.Unorm_8_8_8_8) ||
                   (format == PixelFormats.Uint_8_8_8_8) ||
                   (format == PixelFormats.Unorm_5_5_5_1) ||
                   (format == PixelFormats.Unorm_4_4_4_4) ||
                   (format == PixelFormats.Snorm_8_8_8_8) ||
                   (format == PixelFormats.Sint_8_8_8_8) ||
                   (format == PixelFormats.Unorm_bc1) ||
                   (format == PixelFormats.Unorm_bc2) ||
                   (format == PixelFormats.Unorm_bc3) ||
                   (format == PixelFormats.Unorm_bc7);
        }
    }
}
