﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace EffectMaker.Foundation.Texture
{
    /// <summary>
    /// The color components being used in texture component selector.
    /// </summary>
    public enum ColorComponents : uint
    {
        /// <summary>The red channel.</summary>
        Red = 0x00000000,

        /// <summary>The green channel.</summary>
        Green = 0x00000001,

        /// <summary>The blue channel.</summary>
        Blue = 0x00000002,

        /// <summary>The alpha channel.</summary>
        Alpha = 0x00000003,

        /// <summary>The custom channel 0.</summary>
        Item0 = 0x00000004,

        /// <summary>The custom channel 1.</summary>
        Item1 = 0x00000005,
    }
}
