﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace EffectMaker.Foundation.Primitives
{
    /// <summary>
    /// Generic class for a 1-element vector with integer values.
    /// </summary>
    public class Vector1i : Primitivei
    {
        /// <summary>
        /// Default constructor.
        /// </summary>
        public Vector1i()
        {
        }

        /// <summary>
        /// Copy constructor.
        /// </summary>
        /// <param name="src">The source to copy from.</param>
        public Vector1i(Primitivei src)
            : base(src)
        {
        }

        /// <summary>
        /// Copy constructor.
        /// </summary>
        /// <param name="src">The source array.</param>
        public Vector1i(int[] src)
            : base(src)
        {
        }

        /// <summary>
        /// Setter constructor.
        /// </summary>
        /// <param name="x">The x value to set.</param>
        public Vector1i(int x) :
            base()
        {
            this.Set(x);
        }

        /// <summary>
        /// Get the number of value elements the primitive contains.
        /// </summary>
        public override int Count
        {
            get { return 1; }
        }

        /// <summary>
        /// Get or set the X element of the vector.
        /// </summary>
        public int X
        {
            get { return this[0]; }
            set { this[0] = value; }
        }

        /// <summary>
        /// Set value from the given source.
        /// The set method accepts a primitive or an array with same element type, or
        /// a single element as the X value.
        /// </summary>
        /// <param name="src">The source object.</param>
        /// <returns>True on success.</returns>
        public override bool Set(object src)
        {
            if (src is int)
            {
                this[0] = (int)src;
                return true;
            }
            else
            {
                return base.Set(src);
            }
        }
    }
}
