﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace EffectMaker.Foundation.Interfaces
{
    /// <summary>
    /// Represent a class that can coerce a value.
    /// </summary>
    public interface ICoercer
    {
        /// <summary>
        /// Coerce a value.
        /// </summary>
        /// <param name="input">The input value to coerce.</param>
        /// <returns>Returns the coerced value.</returns>
        object Coerce(object input);
    }

    /// <summary>
    /// Represent a class that can coerce a value.
    /// </summary>
    /// <typeparam name="T">A specific type to coerce.</typeparam>
    public interface ICoercer<T> : ICoercer
    {
        /// <summary>
        /// Coerce a value.
        /// </summary>
        /// <param name="input">The input value to coerce.</param>
        /// <returns>Returns the coerced value.</returns>
        T Coerce(T input);
    }
}
