﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace EffectMaker.Foundation.Disposables
{
    /// <summary>
    /// Represent a disposable object that can delegates the dispose logic to an external method.
    /// </summary>
    public class AnonymousDisposable : IDisposable
    {
        /// <summary>
        /// Stores the onDispose instand given at the constructor.
        /// </summary>
        private Action onDispose;

        /// <summary>
        /// Creates an AnonymousDisposable object.
        /// </summary>
        /// <param name="onDispose">Method called when the object is disposed.</param>
        public AnonymousDisposable(Action onDispose)
        {
            if (onDispose == null)
            {
                throw new ArgumentNullException("onDispose");
            }

            this.onDispose = onDispose;
        }

        /// <summary>
        /// Disposes the object and call the delegate provided at the constructor.
        /// </summary>
        public void Dispose()
        {
            if (this.onDispose != null)
            {
                this.onDispose();
            }

            this.onDispose = null;
        }
    }
}
