﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;

namespace EffectMaker.Foundation.Core
{
    /// <summary>
    /// Enum for primitive value types.
    /// </summary>
    public enum ValueTypes
    {
        /// <summary>
        /// Char型
        /// </summary>
        Char,

        /// <summary>
        /// Byte型
        /// </summary>
        Byte,

        /// <summary>
        /// Short型
        /// </summary>
        Short,

        /// <summary>
        /// Ushort型
        /// </summary>
        Ushort,

        /// <summary>
        /// Int型
        /// </summary>
        Int,

        /// <summary>
        /// Uint型
        /// </summary>
        Uint,

        /// <summary>
        /// Long型
        /// </summary>
        Long,

        /// <summary>
        /// ULong型
        /// </summary>
        ULong,

        /// <summary>
        /// Float型
        /// </summary>
        Float,

        /// <summary>
        /// Double型
        /// </summary>
        Double
    }

    /// <summary>
    /// Enum for last accessed directory types.
    /// </summary>
    public enum LastAccessDirectoryTypes
    {
        /// <summary>
        /// エミッタセット, プレビュー, ワークスペース
        /// </summary>
        Any,

        /// <summary>
        /// ワークスペース
        /// </summary>
        Workspace,

        /// <summary>
        /// エミッタセット
        /// </summary>
        EmitterSet,

        /// <summary>
        /// プレビュー
        /// </summary>
        Preview,

        /// <summary>
        /// テクスチャ
        /// </summary>
        Texture,

        /// <summary>
        /// モデル
        /// </summary>
        Model,

        /// <summary>
        /// アニメーション
        /// </summary>
        ModelAnimation,

        /// <summary>
        /// Custom shader list file.
        /// </summary>
        CustomShaderList,

        /// <summary>
        /// Custom action list file.
        /// </summary>
        CustomActionList,

        /// <summary>
        /// Emitter Extension Parameters list file.
        /// </summary>
        EmitterExtParamsList,

        /// <summary>
        /// コンバイナエディタのプロジェクト
        /// </summary>
        CombinerProject,

        /// <summary>
        /// Effect combiner block definition.
        /// </summary>
        EffectCombinerDefinition,

        /// <summary>
        /// PTCLバイナリ
        /// </summary>
        PtclBinary
    }
}
