﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "TextureData.h"
#include "NativeTextureData.h"

using namespace System;
using namespace System::IO;
using namespace System::Drawing;
using namespace System::Drawing::Imaging;
using namespace System::Collections::Generic;
using namespace System::Runtime::InteropServices;
using namespace nw::g3d::nw4f_3dif;

namespace TexUtils
{

class RSurface;
public ref class Converter
{
public:
    Converter();

    void Initialize();
    void Destroy();

    [System::Security::Permissions::EnvironmentPermissionAttribute(System::Security::Permissions::SecurityAction::LinkDemand)]
    NativeTextureData ^ GetNativeTextureData(textureType ^texture, List<G3dStream ^> ^streams);

    [System::Security::Permissions::EnvironmentPermissionAttribute(System::Security::Permissions::SecurityAction::LinkDemand)]
    array<TextureData ^>^ ConvertTo1d2dStream(textureType ^texture, List<G3dStream ^> ^streams);

    [System::Security::Permissions::EnvironmentPermissionAttribute(System::Security::Permissions::SecurityAction::LinkDemand)]
    array<array<TextureData ^> ^>^ ConvertTo3dStream(textureType ^texture, List<G3dStream ^> ^streams);

    [System::Security::Permissions::EnvironmentPermissionAttribute(System::Security::Permissions::SecurityAction::LinkDemand)]
    array<array<TextureData ^> ^>^ ConvertToCubeStream(textureType ^texture, List<G3dStream ^> ^streams);

    [System::Security::Permissions::EnvironmentPermissionAttribute(System::Security::Permissions::SecurityAction::LinkDemand)]
    array<array<TextureData ^> ^>^ ConvertTo1dArrayStream(textureType ^texture, List<G3dStream ^> ^streams);

    [System::Security::Permissions::EnvironmentPermissionAttribute(System::Security::Permissions::SecurityAction::LinkDemand)]
    array<array<TextureData ^> ^>^ ConvertTo2dArrayStream(textureType ^texture, List<G3dStream ^> ^streams);

    [System::Security::Permissions::EnvironmentPermissionAttribute(System::Security::Permissions::SecurityAction::LinkDemand)]
    array<array<TextureData ^> ^>^ ConvertToCubeArrayStream(textureType ^texture, List<G3dStream ^> ^streams);

private:
    bool isInitialized_;

    bool LoadDll();

    [System::Security::Permissions::EnvironmentPermissionAttribute(System::Security::Permissions::SecurityAction::LinkDemand)]
    array<array<TextureData ^> ^>^ ConvertToCubeStreamInternal(textureType ^texture, List<G3dStream ^> ^streams, bool isCubeArray);

    [System::Security::Permissions::EnvironmentPermissionAttribute(System::Security::Permissions::SecurityAction::LinkDemand)]
    array<TextureData ^>^ ConvertToStreamLinear(		textureType ^texture, RSurface &detiledSurface, int depthLevel);

    [System::Security::Permissions::EnvironmentPermissionAttribute(System::Security::Permissions::SecurityAction::LinkDemand)]
    array<TextureData ^>^ ConvertToStreamCompress(	textureType ^texture, RSurface &detiledSurface, int depthLevel);

    [System::Security::Permissions::EnvironmentPermissionAttribute(System::Security::Permissions::SecurityAction::LinkDemand)]
    array<TextureData ^>^ ConvertToStreamPvrCompress(textureType ^texture, List<G3dStream ^> ^streams, int depthLevel);

    [System::Security::Permissions::EnvironmentPermissionAttribute(System::Security::Permissions::SecurityAction::LinkDemand)]
    array<TextureData ^>^ ConvertToStreamLinear3d(	textureType ^texture, RSurface &detiledSurface, int mipmapLevel);

    [System::Security::Permissions::EnvironmentPermissionAttribute(System::Security::Permissions::SecurityAction::LinkDemand)]
    array<TextureData ^>^ ConvertToStreamCompress3d(	textureType ^texture, RSurface &detiledSurface, int mipmapLevel);

    [System::Security::Permissions::EnvironmentPermissionAttribute(System::Security::Permissions::SecurityAction::LinkDemand)]
    TextureData^ ConvertToStreamLinearInternal(		textureType ^texture, RSurface &detiledSurface, int depthLevel, bool isHintNormal, float bpp, int mipmapLevel);

    [System::Security::Permissions::EnvironmentPermissionAttribute(System::Security::Permissions::SecurityAction::LinkDemand)]
    TextureData^ ConvertToStreamCompressInternal(	textureType ^texture, RSurface &detiledSurface, int depthLevel, bool isHintNormal, float bpp, int mipmapLevel);
};

}	// namespace TexUtils
