﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

using namespace System;
using namespace System::IO;
using namespace System::Drawing;
using namespace System::Drawing::Imaging;
using namespace System::Collections::Generic;
using namespace System::Runtime::InteropServices;
using namespace nw::g3d::nw4f_3dif;

namespace TexUtils
{
public ref class NativeTextureData
{
public:
    property String ^DccPreset
    {
        String ^get()                 { return _DccPreset; }
        void set(String ^value)       { _DccPreset = value; }
    }

    property String ^Hint
    {
        String ^get()                 { return _Hint; }
        void set(String ^value)       { _Hint = value; }
    }

    property array<bool> ^Linear
    {
        array<bool> ^get()                 { return _Linear; }
        void set(array<bool> ^value)       { _Linear = value; }
    }

    property texture_info_dimensionType Dimension
    {
        texture_info_dimensionType get()                 { return _Dimension; }
        void set(texture_info_dimensionType value)       { _Dimension = value; }
    }

    property texture_info_quantize_typeType QuantizeType
    {
        texture_info_quantize_typeType get()                 { return _QuantizeType; }
        void set(texture_info_quantize_typeType value)       { _QuantizeType = value; }
    }

    property bool WeightedCompress
    {
        bool get()                { return _WeightedCompress; }
        void set(bool value)      { _WeightedCompress = value; }
    }

    property texture_info_tile_modeType TileMode
    {
        texture_info_tile_modeType get()                 { return _TileMode; }
        void set(texture_info_tile_modeType value)       { _TileMode = value; }
    }

    property int InitialSwizzle
    {
        int get()                 { return _InitialSwizzle; }
        void set(int value)       { _InitialSwizzle = value; }
    }

    property unsigned int Swizzle
    {
        unsigned int get()                 { return _Swizzle; }
        void set(unsigned int value)       { _Swizzle = value; }
    }

    property unsigned int Alignment
    {
        unsigned int get()                 { return _Alignment; }
        void set(unsigned int value)       { _Alignment = value; }
    }

    property unsigned int Pitch
    {
        unsigned int get()                 { return _Pitch; }
        void set(unsigned int value)       { _Pitch = value; }
    }

    property String ^MipGenFilter
    {
        String ^ get()                { return _MipGenFilter; }
        void set(String ^value)       { _MipGenFilter = value; }
    }

    property array<texture_info_comp_selValue>^ CompSel
    {
        array<texture_info_comp_selValue>^ get()             {   return _CompSel;     }
        void set(array<texture_info_comp_selValue>^ value)   {   _CompSel = value;    }
    }

    property array<unsigned int>^ MipmapOffset
    {
        array<unsigned int>^ get()             {   return _MipmapOffset;     }
        void set(array<unsigned int>^ value)   {   _MipmapOffset = value;    }
    }

    property array<Byte>^ NativeImageStream
    {
        array<Byte>^ get()              {   return _NativeImageStream;  }
        void set(array<Byte>^ value)    {   _NativeImageStream = value; }
    }

private:
    String ^                            _DccPreset;
    String ^                            _Hint;
    array<bool> ^                       _Linear;
    texture_info_dimensionType          _Dimension;
    texture_info_quantize_typeType      _QuantizeType;
    bool                                _WeightedCompress;
    texture_info_tile_modeType          _TileMode;
    int                                 _InitialSwizzle;
    unsigned int                        _Swizzle;
    unsigned int                        _Alignment;
    unsigned int                        _Pitch;
    String ^                            _MipGenFilter;
    array<texture_info_comp_selValue>^  _CompSel;
    array<unsigned int>^                _MipmapOffset;
    array<Byte>^                        _NativeImageStream;
};

}    // namespace TexUtils
