﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef __NativeMessageForwarder_H__
#define __NativeMessageForwarder_H__


using namespace EffectMaker::ShaderConverterLib;


namespace EffectMaker {
namespace ShaderConverterWrapper {

    /// <summary>
    /// The native message forwarder for the shader converter
    /// library.
    /// This message forwarder receives messages from the
    /// native shader converter, and forward the message to
    /// application for process or display.
    /// </summary>
    class NativeMessageForwarder : public IMessageForwarder
    {
    public :
        /// <summary>
        /// Constructor.
        /// </summary>
        /// <param name="pAppForwarder">The message forwarder set from the application.</param>
        NativeMessageForwarder(IDotNetMessageForwarder ^pAppForwarder);

        /// <summary>
        /// Destructor.
        /// </summary>
        virtual ~NativeMessageForwarder();

        /// <summary>
        /// Forward message to the application.
        /// </summary>
        /// <param name="pMessage">The message to output.</param>
        virtual void ForwardMessage(const MessageBase *pMessage);

    private :
        gcroot<IDotNetMessageForwarder^> m_appForwarder;
    };

} // namespace ShaderConverterWrapper
} // namespace EffectMaker

#endif // __NativeMessageForwarder_H__
