﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef __ShaderConverterLib_ILogger_H__
#define __ShaderConverterLib_ILogger_H__


namespace EffectMaker {
namespace ShaderConverterLib {

    /// <summary>
    /// The interface for class that forwards messages to the application.
    /// </summary>
    class LIB_API IMessageForwarder
    {
    public :
        /// <summary>
        /// Forward message to the application.
        /// </summary>
        /// <param name="pMessage">The message to output.</param>
        virtual void ForwardMessage(const MessageBase *pMessage) = 0;
    };

} // namespace ShaderConverterLib
} // namespace EffectMaker

#endif // __ShaderConverterLib_ILogger_H__
