﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "ShaderConverterLib_PCH.h"
#include "Debug.h"

namespace EffectMaker {
namespace ShaderConverterLib {

    IMessageForwarder *g_pMessageForwarder = NULL;

    /// <summary>
    /// Set message forwarder.
    /// </summary>
    /// <param name="pMsgForwarder">The message forwarder.</param>
    void SetMessageForwarder(IMessageForwarder *pMsgForwarder)
    {
        g_pMessageForwarder = pMsgForwarder;
    }

    /// <summary>
    /// Forward a message to the application for processing or displaying.
    /// </summary>
    /// <param name="pMessage">The message to send.</param>
    void ForwardMessage(MessageBase *pMessage)
    {
        if (g_pMessageForwarder != NULL)
        {
            g_pMessageForwarder->ForwardMessage(pMessage);
        }
    }

    /// <summary>
    /// Log message.
    /// (the Unicode version)
    /// </summary>
    /// <param name="szFormat">The format string.</param>
    void LogMessage(const wchar_t *szFormat, ...)
    {
        wchar_t szOutput[1024];

        // Compose the message.
        va_list params;
        va_start(params, szFormat);

        vswprintf_s(szOutput, 1024, szFormat, params);
        wcscat_s(szOutput, 1024, L"\n");

        va_end(params);

        // Output the message to the output window in Visual Studio.
        ::OutputDebugStringW(szOutput);
    }

    /// <summary>
    /// Log message.
    /// (the ASCII version)
    /// </summary>
    /// <param name="szFormat">The format string.</param>
    void LogMessage(const char *szFormat, ...)
    {
        char szOutput[1024];

        // Compose the message.
        va_list params;
        va_start(params, szFormat);

        vsprintf_s(szOutput, 1024, szFormat, params);
        strcat_s(szOutput, 1024, "\n");

        va_end(params);

        // Output the message to the output window in Visual Studio.
        ::OutputDebugStringA(szOutput);
    }

} // namespace ShaderConverterLib
} // namespace EffectMaker
