﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.ServiceModel;

namespace EffectMaker.BusinessLogic.EffectCombinerEditor
{
    /// <summary>
    /// Class for providing the service transferring shader real time from
    /// EffectCombinerEditor to EffectMaker.
    /// </summary>
    [ServiceBehavior(InstanceContextMode = InstanceContextMode.Single)]
    public class EffectCombinerShaderTransferService : Communication.Contracts.IShaderTransferService
    {
        private IEffectCombinerCommunicationBridge communicationBridge = null;

        public EffectCombinerShaderTransferService(IEffectCombinerCommunicationBridge communicationBridge)
        {
            this.communicationBridge = communicationBridge;
        }

        /// <summary>
        /// Implemented transfer method for IShaderTransferService.
        /// </summary>
        /// <param name="filePath">The file path of the shader project.</param>
        /// <param name="shaderCode">The generated shader code.</param>
        /// <returns>The transfer result.</returns>
        public Communication.Contracts.ShaderTransferResult Transfer(string filePath, string shaderCode)
        {
            if (string.IsNullOrEmpty(filePath) == true)
            {
                return Communication.Contracts.ShaderTransferResult.EmitterNotFound;
            }

            this.communicationBridge.SetReceivedShaderSourceCode(filePath, shaderCode);

            return Communication.Contracts.ShaderTransferResult.Success;
        }

        /// <summary>
        /// Implemented connection close handler for IShaderTransferService.
        /// </summary>
        public void OnConnectionClosed()
        {
            this.communicationBridge.ClearReceivedShaderSourceCode();
        }
    }
}
