echo off

set TargetPath=%1
set SigloRoot=%2
set OutDir=%3

set TOOL_DIR=%SigloRoot%\Tools\Graphics\EffectMaker\
SET VC_RUNTIME_DIR=%SigloRoot%\Externals\Binaries\Microsoft.VC.CRT\x64\v110\
SET VC_OPENMP_RUNTIME_DIR=%SigloRoot%\Externals\Binaries\\Microsoft.VC.OpenMP\x64\v110\

call "%VS140COMNTOOLS%vsvars32.bat"
editbin.exe /STACK:32000000 "%TargetPath%"

rem for Resources -----------------
call %~dp0\CopyResourceFiles.bat "%OutDir%" "%TOOL_DIR%"

rem for shaders -----------------
@rem if not exist "%TOOL_DIR%Converter\shader" mkdir "%TOOL_DIR%Converter\shader"

@rem if not exist "%TOOL_DIR%Converter\shader\GLES2" mkdir "%TOOL_DIR%Converter\shader\GLES2"
xcopy /f /y "%OutDir%Converter\shader\GLES2\eft_Particle.fsh"                     "%TOOL_DIR%Converter\shader\GLES2\"
xcopy /f /y "%OutDir%Converter\shader\GLES2\eft_Particle.vsh"                     "%TOOL_DIR%Converter\shader\GLES2\"
xcopy /f /y "%OutDir%Converter\shader\GLES2\eft_ParticleDeclaration.fsh"          "%TOOL_DIR%Converter\shader\GLES2\"
xcopy /f /y "%OutDir%Converter\shader\GLES2\eft_ParticleDeclaration.glsl"         "%TOOL_DIR%Converter\shader\GLES2\"
xcopy /f /y "%OutDir%Converter\shader\GLES2\eft_ParticleDeclaration.vsh"          "%TOOL_DIR%Converter\shader\GLES2\"
xcopy /f /y "%OutDir%Converter\shader\GLES2\eft_ParticleDeclaration_Device.glsl"  "%TOOL_DIR%Converter\shader\GLES2\"
xcopy /f /y "%OutDir%Converter\shader\GLES2\eft_ParticleDeclaration_Windows.glsl" "%TOOL_DIR%Converter\shader\GLES2\"
xcopy /f /y "%OutDir%Converter\shader\GLES2\eft_StreamOut.vsh"                    "%TOOL_DIR%Converter\shader\GLES2\"

xcopy /f /y "%OutDir%Converter\shader\eft_Particle.fsh"                     "%TOOL_DIR%Converter\shader\"
xcopy /f /y "%OutDir%Converter\shader\eft_Particle.vsh"                     "%TOOL_DIR%Converter\shader\"
xcopy /f /y "%OutDir%Converter\shader\eft_ParticleDeclaration.fsh"          "%TOOL_DIR%Converter\shader\"
xcopy /f /y "%OutDir%Converter\shader\eft_ParticleDeclaration.glsl"         "%TOOL_DIR%Converter\shader\"
xcopy /f /y "%OutDir%Converter\shader\eft_ParticleDeclaration.vsh"          "%TOOL_DIR%Converter\shader\"
xcopy /f /y "%OutDir%Converter\shader\eft_ParticleDeclaration_Cafe.glsl"    "%TOOL_DIR%Converter\shader\"
xcopy /f /y "%OutDir%Converter\shader\eft_ParticleDeclaration_Generic.glsl" "%TOOL_DIR%Converter\shader\"
xcopy /f /y "%OutDir%Converter\shader\eft_StreamOut.vsh"                    "%TOOL_DIR%Converter\shader\"
xcopy /f /y "%OutDir%Converter\shader\eft_StreamOutDeclaration.vsh"         "%TOOL_DIR%Converter\shader\"
xcopy /f /y "%OutDir%Converter\shader\gfd.dll"                              "%TOOL_DIR%Converter\shader\"
xcopy /f /y "%OutDir%Converter\shader\shaderUtils.dll"                      "%TOOL_DIR%Converter\shader\"
xcopy /f /y "%OutDir%Converter\shader\shaderUtilsD.dll"                     "%TOOL_DIR%Converter\shader\"
xcopy /f /y "%OutDir%Converter\shader\vfx_ParticleDeclaration_Cafe.glsl"    "%TOOL_DIR%Converter\shader\"
xcopy /f /y "%OutDir%Converter\shader\vfx_ParticleDeclaration_Generic.glsl" "%TOOL_DIR%Converter\shader\"
xcopy /f /y "%OutDir%Converter\shader\vfx_ParticleDeclaration_NX.glsl"      "%TOOL_DIR%Converter\shader\"
xcopy /f /y "%OutDir%Converter\shader\vfx_ParticleDeclaration_NXVk.glsl"    "%TOOL_DIR%Converter\shader\"

rem for specs -----------------
@rem if not exist "%TOOL_DIR%Specs" mkdir "%TOOL_DIR%Specs"
xcopy /f /y "%OutDir%Specs\SpecGeneric.def"      "%TOOL_DIR%Specs\"
xcopy /f /y "%OutDir%Specs\SpecGenericVfx.def"   "%TOOL_DIR%Specs\"
xcopy /f /y "%OutDir%Specs\SpecGenericVfx32.def" "%TOOL_DIR%Specs\"
xcopy /f /y "%OutDir%Specs\SpecGLES2.def"        "%TOOL_DIR%Specs\"
xcopy /f /y "%OutDir%Specs\SpecNX.def"           "%TOOL_DIR%Specs\"
xcopy /f /y "%OutDir%Specs\SpecNX32.def"         "%TOOL_DIR%Specs\"
xcopy /f /y "%OutDir%Specs\SpecNXVk.def"         "%TOOL_DIR%Specs\"

rem for VfxFileFilter -----------------
@rem if not exist "%TOOL_DIR%VfxFileFilter" mkdir "%TOOL_DIR%VfxFileFilter"
xcopy /f /y "%OutDir%VfxFileFilter\VfxConvertFmdb.bat" "%TOOL_DIR%VfxFileFilter\"
xcopy /f /y "%OutDir%VfxFileFilter\VfxConvertFmdb.py"  "%TOOL_DIR%VfxFileFilter\"

rem for g3d updater -----------------
xcopy /f /s /e /y "%OutDir%3dIntermediateFileXsd" "%TOOL_DIR%CoreModules\3dIntermediateFileXsd\"

rem for FE1 updater -----------------
@rem if not exist "%TOOL_DIR%FE1Updater" mkdir "%TOOL_DIR%FE1Updater"
xcopy /f /y "%OutDir%FE1Updater.exe"         "%TOOL_DIR%FE1Updater\"
xcopy /f /y "%OutDir%NWCore.dll"             "%TOOL_DIR%FE1Updater\"
xcopy /f /y "%OutDir%ToolDevelopmentKit.dll" "%TOOL_DIR%FE1Updater\"

rem for CE2 updater -----------------
@rem if not exist "%TOOL_DIR%CE2Updater" mkdir "%TOOL_DIR%CE2Updater"
xcopy /f /y "%OutDir%CE2Updater.exe"         "%TOOL_DIR%CE2Updater\"
xcopy /f /y "%OutDir%NWCore.dll"             "%TOOL_DIR%CE2Updater\"
xcopy /f /y "%OutDir%ToolDevelopmentKit.dll" "%TOOL_DIR%CE2Updater\"

rem for CoreModules -----------------
@rem if not exist "%TOOL_DIR%CoreModules" mkdir "%TOOL_DIR%CoreModules"

xcopy /f /y "%SigloRoot%\Tools\Graphics\3dTools\3dBinaryConverter.dll" "%TOOL_DIR%CoreModules\"

xcopy /f /y "%OutDir%3dBinaryConverterUtils.dll"                       "%TOOL_DIR%CoreModules\"
xcopy /f /y "%OutDir%3dIntermediateFileHelper.dll"                     "%TOOL_DIR%CoreModules\"
xcopy /f /y "%OutDir%3dIntermediateFileLibrary.dll"                    "%TOOL_DIR%CoreModules\"
xcopy /f /y "%OutDir%3dIntermediateFileSerializer.dll"                 "%TOOL_DIR%CoreModules\"
xcopy /f /y "%OutDir%3dIntermediateFileSerializer.XmlSerializers.dll"  "%TOOL_DIR%CoreModules\"
xcopy /f /y "%OutDir%3dIntermediateFileTextureUtility.dll"             "%TOOL_DIR%CoreModules\"
xcopy /f /y "%OutDir%Nintendo.G3dTool.dll"                             "%TOOL_DIR%CoreModules\"
xcopy /f /y "%OutDir%Opal.dll"                                         "%TOOL_DIR%CoreModules\"

xcopy /f /y "%OutDir%EffectMaker.BusinessLogic.dll"            "%TOOL_DIR%CoreModules\"
xcopy /f /y "%OutDir%EffectMaker.Communicator.dll"             "%TOOL_DIR%CoreModules\"
xcopy /f /y "%OutDir%EffectMaker.DataModel.dll"                "%TOOL_DIR%CoreModules\"
xcopy /f /y "%OutDir%EffectMaker.DataModel.Specific.dll"       "%TOOL_DIR%CoreModules\"
xcopy /f /y "%OutDir%EffectMaker.DataModelLogic.dll"           "%TOOL_DIR%CoreModules\"
xcopy /f /y "%OutDir%EffectMaker.Foundation.dll"               "%TOOL_DIR%CoreModules\"
xcopy /f /y "%OutDir%EffectMaker.PrimitiveManager.dll"         "%TOOL_DIR%CoreModules\"
xcopy /f /y "%OutDir%EffectMaker.ProcessBridge.dll"            "%TOOL_DIR%CoreModules\"

xcopy /f /y "%OutDir%EffectMaker.TextureManager.dll"           "%TOOL_DIR%CoreModules\"
xcopy /f /y "%OutDir%EffectMaker.UIControls.dll"               "%TOOL_DIR%CoreModules\"
xcopy /f /y "%OutDir%EffectMaker.UIControls.EffectBrowser.dll" "%TOOL_DIR%CoreModules\"
xcopy /f /y "%OutDir%EffectMaker.UIControls.Specifics.dll"     "%TOOL_DIR%CoreModules\"
xcopy /f /y "%OutDir%EffectMaker.UIDialogs.dll"                "%TOOL_DIR%CoreModules\"
xcopy /f /y "%OutDir%EffectMaker.UILogic.dll"                  "%TOOL_DIR%CoreModules\"

xcopy /f /y "%OutDir%Interop.IWshRuntimeLibrary.dll"           "%TOOL_DIR%CoreModules\"
xcopy /f /y "%OutDir%IronPython.dll"                           "%TOOL_DIR%CoreModules\"
xcopy /f /y "%OutDir%IronPython.Modules.dll"                   "%TOOL_DIR%CoreModules\"
xcopy /f /y "%OutDir%Microsoft.Dynamic.dll"                    "%TOOL_DIR%CoreModules\"
xcopy /f /y "%OutDir%Microsoft.Scripting.dll"                  "%TOOL_DIR%CoreModules\"
xcopy /f /y "%OutDir%Microsoft.Scripting.Metadata.dll"         "%TOOL_DIR%CoreModules\"
xcopy /f /y "%OutDir%System.Interactive.dll"                   "%TOOL_DIR%CoreModules\"

xcopy /f /y "%OutDir%Nintendo.Tm.dll"                          "%TOOL_DIR%CoreModules\"
xcopy /f /y "%OutDir%Nintendo.InGameEditing.Communication.dll" "%TOOL_DIR%CoreModules\"
xcopy /f /y "%OutDir%Nintendo.ToolFoundation.dll"              "%TOOL_DIR%CoreModules\"
xcopy /f /y "%OutDir%Nintendo.ToolFoundation.Windows.dll"      "%TOOL_DIR%CoreModules\"
xcopy /f /y "%OutDir%Nintendo.ToolFoundation.WPF.dll"          "%TOOL_DIR%CoreModules\"
xcopy /f /y "%OutDir%ToolFoundation.dll"                       "%TOOL_DIR%CoreModules\"

xcopy /f /y "%OutDir%Blocks.Core.dll"                          "%TOOL_DIR%CoreModules\"
xcopy /f /y "%OutDir%Communication.Contracts.dll"              "%TOOL_DIR%CoreModules\"
xcopy /f /y "%OutDir%Communication.Core.dll"                   "%TOOL_DIR%CoreModules\"
xcopy /f /y "%OutDir%EffectCombiner.Core.dll"                  "%TOOL_DIR%CoreModules\"
xcopy /f /y "%OutDir%EffectCombiner.Data.dll"                  "%TOOL_DIR%CoreModules\"
xcopy /f /y "%OutDir%EffectCombiner.Generator.dll"             "%TOOL_DIR%CoreModules\"
xcopy /f /y "%OutDir%EffectCombiner.Primitives.Generation.dll" "%TOOL_DIR%CoreModules\"
xcopy /f /y "%OutDir%EffectDefinitions.dll"                    "%TOOL_DIR%CoreModules\"
xcopy /f /y "%OutDir%EffectMaker.EffectCombinerBridge.dll"     "%TOOL_DIR%CoreModules\"
xcopy /f /y "%OutDir%Renderer2D.Core.dll"                      "%TOOL_DIR%CoreModules\"
xcopy /f /y "%OutDir%ShaderGenerator.Core.dll"                 "%TOOL_DIR%CoreModules\"
xcopy /f /y "%OutDir%ShaderGenerator.GLSL.dll"                 "%TOOL_DIR%CoreModules\"
xcopy /f /y "%OutDir%ShaderTyping.dll"                         "%TOOL_DIR%CoreModules\"
xcopy /f /y "%OutDir%Workflow.Core.dll"                        "%TOOL_DIR%CoreModules\"

xcopy /f /y "%OutDir%WeifenLuo.WinFormsUI.Docking.dll"    "%TOOL_DIR%CoreModules\"

xcopy /f /y "%VC_RUNTIME_DIR%msvcr110.dll"        "%TOOL_DIR%CoreModules\"
xcopy /f /y "%VC_RUNTIME_DIR%msvcp110.dll"        "%TOOL_DIR%CoreModules\"
xcopy /f /y "%VC_OPENMP_RUNTIME_DIR%vcomp110.dll" "%TOOL_DIR%CoreModules\"

rem for / -----------------
xcopy /f /y "%OutDir%EffectMaker.exe"        "%TOOL_DIR%"
xcopy /f /y "%OutDir%EffectMaker.exe.config" "%TOOL_DIR%"
