﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using EffectMaker.BusinessLogic.Options;

namespace EffectMaker.Application.CommandLine
{
    /// <summary>
    /// 並列実行するジョブ数を設定します。
    /// </summary>
    public class JobsNumberProcessor : CommandLineProcessorBase
    {
        /// <summary>
        /// 並列実行するジョブ数です。
        /// </summary>
        private int jobsNumber;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="workingData">作業データ</param>
        /// <param name="jobsNumber">ジョブ数</param>
        public JobsNumberProcessor(CommandLineWorkingData workingData, int jobsNumber)
            : base(workingData)
        {
            this.jobsNumber = jobsNumber;
        }

        /// <summary>
        /// エラーログを取得します。
        /// </summary>
        public override string ErrorReport { get { return string.Empty; } }

        /// <summary>
        /// 設定処理を行います。
        /// </summary>
        /// <returns>処理が正常に完了したときtrue, それ以外はfalseを返します。</returns>
        public override bool Setup()
        {
            OptionStore.RuntimeOptions.JobsNumber = this.jobsNumber;
            OptionStore.RuntimeOptions.IsJobsNumberAssigned = true;
            return true;
        }

        /// <summary>
        /// コマンドライン処理を行います。
        /// </summary>
        /// <returns>処理が正常に完了したときtrue, それ以外はfalseを返します。</returns>
        public override bool Process()
        {
            return true;
        }

        /// <summary>
        /// 書き換えた設定などを復元します。
        /// </summary>
        public override void Cleanup()
        {
            OptionStore.RuntimeOptions.JobsNumber = 1;
            OptionStore.RuntimeOptions.IsJobsNumberAssigned = false;
        }
    }
}
