﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using ComboBoxItemType = System.Collections.Generic.KeyValuePair<string, object>;
using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Serialization;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Xml.Serialization;

using CurrVersion = EffectMaker.DataModel.Specific.DataModels;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer;

namespace EffectMaker.DataModel.Specific.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// 連結式ストライプ
    /// </summary>
    [Serializable]
    public class StripeComplexUserData : UserDataBase
    {
        /// <summary>
        /// 履歴の加速度。
        /// </summary>
        private Vector3f historyAcceleration = null;

        /// <summary>
        /// 履歴初速の変化周期（XYZ）
        /// </summary>
        private Vector3f historyInitVecRotateCycle = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public StripeComplexUserData() :
            base()
        {
            this.StripeType = 64;
            this.FollowEmitter = false;
            this.Option = 0;
            this.TexCoordType = 0;
            this.NumHistory = 60;
            this.ConnectionType = 0;
            this.StartSliceAlpha = 1.0f;
            this.EndSliceAlpha = 1.0f;
            this.HistInterpolation = 0;
            this.DirInterpolation = 0;
            this.NumDivide = 1;
            this.HistoryTailVecRegulation = 1.0f;
            this.HistoryTailVecSpeed = 0.0f;
            this.HistoryAirRegist = 1.0f;
            this.HistoryAcceleration = new Vector3f(0.0f, 0.0f, 0.0f);
            this.HistoryInitVecRotateCycle = new Vector3f(1.0f, 1.0f, 1.0f);

            this.PostConstruct();
        }

        /// <summary>
        /// 計算方式
        /// </summary>
        [DataModelPropertyGuid("5c3c335a-797f-4ea3-aeb6-b70fb839bb6d")]
        public int StripeType { get; set; }

        /// <summary>
        /// エミッタに完全追従
        /// </summary>
        [DataModelPropertyGuid("6f47ff97-44f5-4863-81be-bae03e6e1675")]
        public bool FollowEmitter { get; set; }

        /// <summary>
        /// オプション
        /// </summary>
        [DataModelPropertyGuid("889c48b3-4646-4087-99c4-e462cb732440")]
        public int Option { get; set; }

        /// <summary>
        /// テクスチャリング
        /// </summary>
        [DataModelPropertyGuid("0b2ef3e3-3ce1-4655-b01a-25cdb8ba2147")]
        public int TexCoordType { get; set; }

        /// <summary>
        /// 履歴の数
        /// </summary>
        [DataModelPropertyGuid("a57ca93f-837f-4c03-ab20-716adc454abe")]
        public int NumHistory { get; set; }

        /// <summary>
        /// 接続タイプ
        /// </summary>
        [DataModelPropertyGuid("26429a1c-dc0b-4c92-87fb-91e4f6b56dcd")]
        public int ConnectionType { get; set; }

        /// <summary>
        /// 先端α
        /// </summary>
        [DataModelPropertyGuid("85c39097-58c3-43fc-bbbe-b8caa4baf23c")]
        public float StartSliceAlpha { get; set; }

        /// <summary>
        /// 末端α
        /// </summary>
        [DataModelPropertyGuid("d3e35980-1970-4861-91fc-29ec9f3990f6")]
        public float EndSliceAlpha { get; set; }

        /// <summary>
        /// 履歴補間パラメータ
        /// </summary>
        [DataModelPropertyGuid("13dadd5d-f566-487d-ae09-d629394e334e")]
        public float HistInterpolation { get; set; }

        /// <summary>
        /// 方向補間率
        /// </summary>
        [DataModelPropertyGuid("ad84425c-c022-42f5-99e7-f042ee69d0f9")]
        public float DirInterpolation { get; set; }

        /// <summary>
        /// 分割数
        /// </summary>
        [DataModelPropertyGuid("f8c065a0-dafe-40d8-9eba-52f60be10504")]
        public int NumDivide { get; set; }

        /// <summary>
        /// ストライプタイプ.
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("0665e12f-f909-4a41-a1c6-d3c712b577ae")]
        public IEnumerable<ComboBoxItemType> StripeTypeItems
        {
            get
            {
                return new ComboBoxItemType[]
                {
                    new ComboBoxItemType("ビルボードストライプ", 0),
                    new ComboBoxItemType("エミッタ行列ストライプ", 1),
                    new ComboBoxItemType("エミッタの上下に伸ばす", 2),
                };
            }
        }

        /// <summary>
        /// オプションタイプ.
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("a0333b7f-b335-4a09-ad4b-08b7864d2e99")]
        public IEnumerable<ComboBoxItemType> OptionTypeItems
        {
            get
            {
                return new ComboBoxItemType[]
                {
                    new ComboBoxItemType("通常", 0),
                    new ComboBoxItemType("クロス", 1),
                };
            }
        }

        /// <summary>
        /// テクスチャ座標タイプ.
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("e6f7b82c-67f8-4961-89be-ae79e4117e6d")]
        public IEnumerable<ComboBoxItemType> TexCoordTypeItems
        {
            get
            {
                return new ComboBoxItemType[]
                {
                    new ComboBoxItemType("全て貼る", 0),
                    new ComboBoxItemType("描画範囲に合わせて貼る", 1),
                };
            }
        }

        /// <summary>
        /// 接続タイプ.
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("75da6541-ec96-47fd-8627-007aec5c4804")]
        public IEnumerable<ComboBoxItemType> ConnectionTypeItems
        {
            get
            {
                return new ComboBoxItemType[]
                {
                    new ComboBoxItemType("通常", 0),
                    new ComboBoxItemType("先端に繋ぐ", 1),
                    new ComboBoxItemType("エミッタに繋ぐ", 2),
                };
            }
        }

        /// <summary>
        /// 履歴の初速方向の変動率。
        /// </summary>
        [DataModelPropertyGuid("0bbb2e65-4760-48d8-8017-fa45df04fa3f")]
        public float HistoryTailVecRegulation { get; set; }

        /// <summary>
        /// 履歴初期速度の強さ
        /// </summary>
        [DataModelPropertyGuid("8827c477-d862-4948-a8b8-2ed12822ce8c")]
        public float HistoryTailVecSpeed { get; set; }

        /// <summary>
        /// 履歴の空気抵抗
        /// </summary>
        [DataModelPropertyGuid("13ca44f3-44dc-428e-8f3e-0b75963723d8")]
        public float HistoryAirRegist { get; set; }

        /// <summary>
        /// 履歴の加速度。
        /// </summary>
        [DataModelPropertyGuid("84a63cef-f98e-4a81-9eac-e07f5cbc0b91")]
        public Vector3f HistoryAcceleration
        {
            get { return this.GetObjectFromField(ref this.historyAcceleration, false); }
            set { this.SetISettableToField(ref this.historyAcceleration, value); }
        }

        /// <summary>
        /// 履歴初速の変化周期（XYZ）
        /// </summary>
        [DataModelPropertyGuid("484e418a-9b8a-418c-9033-b7015b1b6a6c")]
        public Vector3f HistoryInitVecRotateCycle
        {
            get { return this.GetObjectFromField(ref this.historyInitVecRotateCycle, false); }
            set { this.SetISettableToField(ref this.historyInitVecRotateCycle, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.StripeComplexUserData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.StripeType = srcDataModel.StripeType;
            this.FollowEmitter = srcDataModel.FollowEmitter;
            this.Option = srcDataModel.Option;
            this.TexCoordType = srcDataModel.TexCoordType;
            this.NumHistory = srcDataModel.NumHistory;
            this.ConnectionType = srcDataModel.ConnectionType;
            this.StartSliceAlpha = srcDataModel.StartSliceAlpha;
            this.EndSliceAlpha = srcDataModel.EndSliceAlpha;
            this.HistInterpolation = srcDataModel.HistInterpolation;
            this.DirInterpolation = srcDataModel.DirInterpolation;
            this.NumDivide = srcDataModel.NumDivide;
            this.HistoryTailVecRegulation = srcDataModel.HistoryTailVecRegulation;
            this.HistoryTailVecSpeed = srcDataModel.HistoryTailVecSpeed;
            this.HistoryAirRegist = srcDataModel.HistoryAirRegist;
            this.HistoryAcceleration = srcDataModel.HistoryAcceleration;
            this.HistoryInitVecRotateCycle = srcDataModel.HistoryInitVecRotateCycle;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "StripeType", this.StripeType);
            this.WriteElement(context, "FollowEmitter", this.FollowEmitter);
            this.WriteElement(context, "Option", this.Option);
            this.WriteElement(context, "TexCoordType", this.TexCoordType);
            this.WriteElement(context, "NumHistory", this.NumHistory);
            this.WriteElement(context, "ConnectionType", this.ConnectionType);
            this.WriteElement(context, "StartSliceAlpha", this.StartSliceAlpha);
            this.WriteElement(context, "EndSliceAlpha", this.EndSliceAlpha);
            this.WriteElement(context, "HistInterpolation", this.HistInterpolation);
            this.WriteElement(context, "DirInterpolation", this.DirInterpolation);
            this.WriteElement(context, "NumDivide", this.NumDivide);
            this.WriteElement(context, "HistoryTailVecRegulation", this.HistoryTailVecRegulation);
            this.WriteElement(context, "HistoryTailVecSpeed", this.HistoryTailVecSpeed);
            this.WriteElement(context, "HistoryAirRegist", this.HistoryAirRegist);
            this.WriteElement(context, "HistoryAcceleration", this.HistoryAcceleration);
            this.WriteElement(context, "HistoryInitVecRotateCycle", this.HistoryInitVecRotateCycle);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.StripeType = this.ReadElement(context, "StripeType", this.StripeType);
            this.FollowEmitter = this.ReadElement(context, "FollowEmitter", this.FollowEmitter);
            this.Option = this.ReadElement(context, "Option", this.Option);
            this.TexCoordType = this.ReadElement(context, "TexCoordType", this.TexCoordType);
            this.NumHistory = this.ReadElement(context, "NumHistory", this.NumHistory);
            this.ConnectionType = this.ReadElement(context, "ConnectionType", this.ConnectionType);
            this.StartSliceAlpha = this.ReadElement(context, "StartSliceAlpha", this.StartSliceAlpha);
            this.EndSliceAlpha = this.ReadElement(context, "EndSliceAlpha", this.EndSliceAlpha);
            this.HistInterpolation = this.ReadElement(context, "HistInterpolation", this.HistInterpolation);
            this.DirInterpolation = this.ReadElement(context, "DirInterpolation", this.DirInterpolation);
            this.NumDivide = this.ReadElement(context, "NumDivide", this.NumDivide);
            this.HistoryTailVecRegulation = this.ReadElement(context, "HistoryTailVecRegulation", this.HistoryTailVecRegulation);
            this.HistoryTailVecSpeed = this.ReadElement(context, "HistoryTailVecSpeed", this.HistoryTailVecSpeed);
            this.HistoryAirRegist = this.ReadElement(context, "HistoryAirRegist", this.HistoryAirRegist);
            this.HistoryAcceleration = this.ReadElement(context, "HistoryAcceleration", this.HistoryAcceleration);
            this.HistoryInitVecRotateCycle = this.ReadElement(context, "HistoryInitVecRotateCycle", this.HistoryInitVecRotateCycle);

            return success;
        }
    }
}
