﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using ComboBoxItemType = System.Collections.Generic.KeyValuePair<string, object>;
using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.DataModelLogic;
using EffectMaker.Foundation.Serialization;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Xml.Serialization;

using CurrVersion = EffectMaker.DataModel.Specific.DataModels;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer;

namespace EffectMaker.DataModel.Specific.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// ストライプノード/連結式タブ/連結式ストライプグループデータです。
    /// </summary>
    [Serializable]
    public class EPStripeComplexData : UserDataBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EPStripeComplexData() :
            base()
        {
            this.StripeType = 0;
            this.FollowEmitter = false;
            this.Option = 0;
            this.TexCoordType = 0;
            this.NumDivisions = 0;
            this.ConnectionType = 0;
            this.StartSliceAlpha = 1.0f;
            this.EndSliceAlpha = 1.0f;
            this.HistInterpolation = 0.0f;
            this.DirInterpolation = 0.0f;

            this.PostConstruct();
        }

        /// <summary>
        /// 計算方法を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("1d3c8123-95a3-4bf5-bb07-7ab44d732cde")]
        public int StripeType { get; set; }

        /// <summary>
        ///
        /// </summary>
        [DataModelPropertyGuid("09593f1e-c554-476c-acdc-7ca78223f1cb")]
        public bool FollowEmitter { get; set; }

        /// <summary>
        /// オプションの種類を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("b967ff49-7b62-4667-9e1a-cc12e370e995")]
        public int Option { get; set; }

        /// <summary>
        /// テクスチャリングの種類を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("843f273e-b333-4d71-a002-ac476e77c517")]
        public int TexCoordType { get; set; }

        /// <summary>
        /// 分割数を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("1b8ce0f6-0ff6-482b-8212-07f72a3c6602")]
        public int NumDivisions { get; set; }

        /// <summary>
        /// 接続タイプを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("314bb50c-f16d-418e-879f-d3c1f34e9f1b")]
        public int ConnectionType { get; set; }

        /// <summary>
        /// 先端αの値を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("ed059251-8d42-4631-b7c8-28b51a5ca256")]
        public float StartSliceAlpha { get; set; }

        /// <summary>
        /// 末端αの値を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("7d709214-5f91-4db3-ba75-75a3b3a18448")]
        public float EndSliceAlpha { get; set; }

        /// <summary>
        /// 履歴補間パラメータを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("9746660c-fab9-4081-a5f5-f982bbbfdc8c")]
        public float HistInterpolation { get; set; }

        /// <summary>
        /// 方向補間率を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("f2a22c20-70fe-47bd-8c83-f14fb01ba50c")]
        public float DirInterpolation { get; set; }

        /// <summary>
        /// 計算方法の選択肢を取得します。
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("7d62833d-9a9f-4733-9750-ff0327f913c2")]
        public IEnumerable<ComboBoxItemType> StripeTypeItems
        {
            get
            {
                return new ComboBoxItemType[]
                {
                    new ComboBoxItemType(ResourceAccessor.GetString("EPStripeComboBoxItemBillboard"), 0),
                    new ComboBoxItemType(ResourceAccessor.GetString("EPStripeComboBoxItemEmitterMatrix"), 1),
                    new ComboBoxItemType(ResourceAccessor.GetString("EPStripeComboBoxItemEmitterTopBottom"), 2),
                };
            }
        }

        /// <summary>
        /// オプションの選択肢を取得します。
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("97de4ba5-590b-402c-87a3-5571c98b6946")]
        public IEnumerable<ComboBoxItemType> OptionTypeItems
        {
            get
            {
                return new ComboBoxItemType[]
                {
                    new ComboBoxItemType(ResourceAccessor.GetString("EPStripeComboBoxItemNormal"), 0),
                    new ComboBoxItemType(ResourceAccessor.GetString("EPStripeComboBoxItemCross"), 1),
                };
            }
        }

        /// <summary>
        /// テクスチャリングの選択肢を取得します。
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("d9b6a42d-fc48-4b44-926e-8468d2e49dc5")]
        public IEnumerable<ComboBoxItemType> TexCoordTypeItems
        {
            get
            {
                return new ComboBoxItemType[]
                {
                    new ComboBoxItemType(ResourceAccessor.GetString("EPStripeComboBoxItemPutAll"), 0),
                    new ComboBoxItemType(ResourceAccessor.GetString("EPStripeComboBoxItemPutFit"), 1),
                };
            }
        }

        /// <summary>
        /// 接続タイプの選択肢を取得します。
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("feffad81-114a-41f1-b3d9-efa0162e838f")]
        public IEnumerable<ComboBoxItemType> ConnectionTypeItems
        {
            get
            {
                return new ComboBoxItemType[]
                {
                    new ComboBoxItemType(ResourceAccessor.GetString("EPStripeComboBoxItemConnectNormal"), 0),
                    new ComboBoxItemType(ResourceAccessor.GetString("EPStripeComboBoxItemConnectTop"), 1),
                    new ComboBoxItemType(ResourceAccessor.GetString("EPStripeComboBoxItemConnectEmitter"), 2),
                };
            }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.EPStripeComplexData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.StripeType = srcDataModel.StripeType;
            this.FollowEmitter = srcDataModel.FollowEmitter;
            this.Option = srcDataModel.Option;
            this.TexCoordType = srcDataModel.TexCoordType;
            this.NumDivisions = srcDataModel.NumDivisions;
            this.ConnectionType = srcDataModel.ConnectionType;
            this.StartSliceAlpha = srcDataModel.StartSliceAlpha;
            this.EndSliceAlpha = srcDataModel.EndSliceAlpha;
            this.HistInterpolation = srcDataModel.HistInterpolation;
            this.DirInterpolation = srcDataModel.DirInterpolation;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "StripeType", this.StripeType);
            this.WriteElement(context, "FollowEmitter", this.FollowEmitter);
            this.WriteElement(context, "Option", this.Option);
            this.WriteElement(context, "TexCoordType", this.TexCoordType);
            this.WriteElement(context, "NumDivisions", this.NumDivisions);
            this.WriteElement(context, "ConnectionType", this.ConnectionType);
            this.WriteElement(context, "StartSliceAlpha", this.StartSliceAlpha);
            this.WriteElement(context, "EndSliceAlpha", this.EndSliceAlpha);
            this.WriteElement(context, "HistInterpolation", this.HistInterpolation);
            this.WriteElement(context, "DirInterpolation", this.DirInterpolation);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.StripeType = this.ReadElement(context, "StripeType", this.StripeType);
            this.FollowEmitter = this.ReadElement(context, "FollowEmitter", this.FollowEmitter);
            this.Option = this.ReadElement(context, "Option", this.Option);
            this.TexCoordType = this.ReadElement(context, "TexCoordType", this.TexCoordType);
            this.NumDivisions = this.ReadElement(context, "NumDivisions", this.NumDivisions);
            this.ConnectionType = this.ReadElement(context, "ConnectionType", this.ConnectionType);
            this.StartSliceAlpha = this.ReadElement(context, "StartSliceAlpha", this.StartSliceAlpha);
            this.EndSliceAlpha = this.ReadElement(context, "EndSliceAlpha", this.EndSliceAlpha);
            this.HistInterpolation = this.ReadElement(context, "HistInterpolation", this.HistInterpolation);
            this.DirInterpolation = this.ReadElement(context, "DirInterpolation", this.DirInterpolation);

            return success;
        }
    }
}
