﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Reflection;

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.DataModelLogic.BinaryConverters;
using EffectMaker.DataModelLogic.BinaryData;
using EffectMaker.DataModelLogic.Utilities;

using ConverterParam = System.Collections.Generic.KeyValuePair<string, object>;

namespace EffectMaker.DataModelLogic.BinaryConversionInfo
{
    /// <summary>
    /// [AUTO GENERATED CLASS, DO NOT MODIFY]
    /// Auto-generated class for converting data model values.
    /// </summary>
    public class CustomActionSetting7BinaryConversionInfo : BinaryConversionInfoBase
    {
        /// <summary>The root binary structure definition.</summary>
        private static BinaryStructDefinition rootBinaryDefinition = null;

        /// <summary>The list of instance.</summary>
        private static Dictionary<DataModelBase, BinaryConversionInfoBase> instanceMap = null;

        /// <summary>The root binary structure instance.</summary>
        private BinaryStructInstance rootBinaryInstance = null;

        /// <summary>
        /// The constructor.
        /// </summary>
        static CustomActionSetting7BinaryConversionInfo()
        {
            instanceMap = new Dictionary<DataModelBase, BinaryConversionInfoBase>();

            var customActionSetting7BinaryData = new BinaryStructDefinition(typeof(CustomActionSetting7)) { HasBinaryHeader = true };

            // Output : flag0
            // Inputs : Flag0
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting7BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("Flag0", new Guid("314f6176-71c5-4053-8e99-5c5e35e3c6c2"))
            );

            // Output : intParam0
            // Inputs : IntParam0
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting7BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("IntParam0", new Guid("4e82341e-88ad-4fba-87dd-edb7cf13f405"))
            );

            // Output : intParam1
            // Inputs : IntParam1
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting7BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("IntParam1", new Guid("eec7b478-0048-4608-a4d1-fffc8a012b60"))
            );

            // Output : intParam2
            // Inputs : IntParam2
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting7BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("IntParam2", new Guid("25fea63d-9782-4392-9b89-6d29ac67707f"))
            );

            // Output : intParam3
            // Inputs : IntParam3
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting7BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("IntParam3", new Guid("496c68f3-c359-4369-a65d-e618d1a42923"))
            );

            // Output : intParam4
            // Inputs : IntParam4
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting7BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("IntParam4", new Guid("375581a0-921c-4c49-958c-3aa973e7bfd0"))
            );

            // Output : intParam5
            // Inputs : IntParam5
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting7BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("IntParam5", new Guid("ce84d890-6110-4803-926a-c159cc40ea95"))
            );

            // Output : floatParam0
            // Inputs : FloatParam0
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting7BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("FloatParam0", new Guid("196215b1-a96a-4a68-bb33-e999485fc4a5"))
            );

            // Output : floatParam1
            // Inputs : FloatParam1
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting7BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("FloatParam1", new Guid("b31f0223-e309-4567-8ef7-673fc4577958"))
            );

            // Output : floatParam2
            // Inputs : FloatParam2
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting7BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("FloatParam2", new Guid("1ebbf40e-2675-4d5d-8b5e-ac9902f91201"))
            );

            // Output : floatParam3
            // Inputs : FloatParam3
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting7BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("FloatParam3", new Guid("e955c2bb-b64e-4188-b524-efb465a5b742"))
            );

            // Output : floatParam4
            // Inputs : FloatParam4
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting7BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("FloatParam4", new Guid("4f44174f-f2c0-4eb9-9abe-26302b05a099"))
            );

            // Output : floatParam5
            // Inputs : FloatParam5
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting7BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("FloatParam5", new Guid("9a4d5e91-760d-4613-9cfb-174d435a864c"))
            );

            // Output : floatParam6
            // Inputs : FloatParam6
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting7BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("FloatParam6", new Guid("83dc5ccc-21b8-4b16-87f1-4afb0ec8bfcb"))
            );

            // Output : floatParam7
            // Inputs : FloatParam7
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting7BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("FloatParam7", new Guid("4919222c-c893-4111-9421-09785fd60128"))
            );


            //-----------------------------------------------------------------
            // Save the binary structure definition.
            //-----------------------------------------------------------------
            rootBinaryDefinition = customActionSetting7BinaryData;
        }

        /// <summary>
        /// The constructor.
        /// </summary>
        /// <param name="dataModel">The data model to convert.</param>
        private CustomActionSetting7BinaryConversionInfo(DataModelBase dataModel)
        {
            /* DO_NOTHING */
        }

        /// <summary>
        /// Dispose.
        /// </summary>
        public override void Dispose()
        {
            /* DO_NOTHING */
        }

        /// <summary>
        /// Handle DataModelCreated event from the manager.
        /// </summary>
        /// <param name="sender">The sender of the event, should be null.</param>
        /// <param name="dataModel">The created data model.</param>
        private static void OnDataModelCreated(object sender, DataModelBase dataModel)
        {
            /* DO_NOTHING */
        }

        /// <summary>
        /// Handle DataModelCreated event from the manager.
        /// </summary>
        /// <param name="sender">The sender of the event, should be null.</param>
        /// <param name="dataModel">The created data model.</param>
        private static void OnDataModelDestroyed(object sender, DataModelBase dataModel)
        {
            /* DO_NOTHING */
        }
    }
}
