﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Reflection;

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.DataModelLogic.BinaryConverters;
using EffectMaker.DataModelLogic.BinaryData;
using EffectMaker.DataModelLogic.Utilities;

using ConverterParam = System.Collections.Generic.KeyValuePair<string, object>;

namespace EffectMaker.DataModelLogic.BinaryConversionInfo
{
    /// <summary>
    /// [AUTO GENERATED CLASS, DO NOT MODIFY]
    /// Auto-generated class for converting data model values.
    /// </summary>
    public class CustomActionSetting6BinaryConversionInfo : BinaryConversionInfoBase
    {
        /// <summary>The root binary structure definition.</summary>
        private static BinaryStructDefinition rootBinaryDefinition = null;

        /// <summary>The list of instance.</summary>
        private static Dictionary<DataModelBase, BinaryConversionInfoBase> instanceMap = null;

        /// <summary>The root binary structure instance.</summary>
        private BinaryStructInstance rootBinaryInstance = null;

        /// <summary>
        /// The constructor.
        /// </summary>
        static CustomActionSetting6BinaryConversionInfo()
        {
            instanceMap = new Dictionary<DataModelBase, BinaryConversionInfoBase>();

            var customActionSetting6BinaryData = new BinaryStructDefinition(typeof(CustomActionSetting6)) { HasBinaryHeader = true };

            // Output : flag0
            // Inputs : Flag0
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting6BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("Flag0", new Guid("b971ea12-39bd-4944-b61a-6d93bb56490f"))
            );

            // Output : intParam0
            // Inputs : IntParam0
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting6BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("IntParam0", new Guid("7b9a8ee2-2d62-46ec-ae4f-5e1e0cfa43e0"))
            );

            // Output : intParam1
            // Inputs : IntParam1
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting6BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("IntParam1", new Guid("86bc7d4e-4ade-4b56-94ee-7de923d77a79"))
            );

            // Output : intParam2
            // Inputs : IntParam2
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting6BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("IntParam2", new Guid("c1d8b5c1-986b-4618-9dc7-cef92c04763a"))
            );

            // Output : intParam3
            // Inputs : IntParam3
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting6BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("IntParam3", new Guid("e66c0acc-17b3-41c7-9c18-f44d2a645c29"))
            );

            // Output : intParam4
            // Inputs : IntParam4
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting6BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("IntParam4", new Guid("603e1b9f-ee92-49e5-a0d6-72fee7f576ef"))
            );

            // Output : intParam5
            // Inputs : IntParam5
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting6BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("IntParam5", new Guid("b30e959d-603b-499a-929a-2b769b3e481e"))
            );

            // Output : floatParam0
            // Inputs : FloatParam0
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting6BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("FloatParam0", new Guid("61b1179d-7fef-4a23-b7c1-cbd9a671a9b6"))
            );

            // Output : floatParam1
            // Inputs : FloatParam1
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting6BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("FloatParam1", new Guid("f914ed5a-e2cf-4868-95b0-66a41759a65f"))
            );

            // Output : floatParam2
            // Inputs : FloatParam2
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting6BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("FloatParam2", new Guid("943197b6-4901-4be7-95d3-f43d590ef804"))
            );

            // Output : floatParam3
            // Inputs : FloatParam3
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting6BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("FloatParam3", new Guid("6c033dcf-ca05-4125-8406-752dc41117ab"))
            );

            // Output : floatParam4
            // Inputs : FloatParam4
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting6BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("FloatParam4", new Guid("793730f9-11b0-4b00-a9d4-17db046189af"))
            );

            // Output : floatParam5
            // Inputs : FloatParam5
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting6BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("FloatParam5", new Guid("73c74bee-27dc-4972-b9f3-0fbf9cee500c"))
            );

            // Output : floatParam6
            // Inputs : FloatParam6
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting6BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("FloatParam6", new Guid("c21fa4ad-286d-4d71-9ae5-968fd970751f"))
            );

            // Output : floatParam7
            // Inputs : FloatParam7
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting6BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("FloatParam7", new Guid("670a876a-9d88-44a1-8ee2-01f833c3ad3f"))
            );


            //-----------------------------------------------------------------
            // Save the binary structure definition.
            //-----------------------------------------------------------------
            rootBinaryDefinition = customActionSetting6BinaryData;
        }

        /// <summary>
        /// The constructor.
        /// </summary>
        /// <param name="dataModel">The data model to convert.</param>
        private CustomActionSetting6BinaryConversionInfo(DataModelBase dataModel)
        {
            /* DO_NOTHING */
        }

        /// <summary>
        /// Dispose.
        /// </summary>
        public override void Dispose()
        {
            /* DO_NOTHING */
        }

        /// <summary>
        /// Handle DataModelCreated event from the manager.
        /// </summary>
        /// <param name="sender">The sender of the event, should be null.</param>
        /// <param name="dataModel">The created data model.</param>
        private static void OnDataModelCreated(object sender, DataModelBase dataModel)
        {
            /* DO_NOTHING */
        }

        /// <summary>
        /// Handle DataModelCreated event from the manager.
        /// </summary>
        /// <param name="sender">The sender of the event, should be null.</param>
        /// <param name="dataModel">The created data model.</param>
        private static void OnDataModelDestroyed(object sender, DataModelBase dataModel)
        {
            /* DO_NOTHING */
        }
    }
}
