﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;

namespace CombinerNodeEditor.Dialog
{
    /// <summary>
    /// ApplyTemplateDialog.xaml の相互作用ロジック
    /// </summary>
    public partial class ApplyTemplateDialog : Window
    {
        private NodeDesc node = null;

        public ApplyTemplateDialog(NodeDesc node)
        {
            // プレビュー用に選択中のノードをバインド
            this.node = node;
            this.DataContext = node;

            InitializeComponent();

            //this.NodeViewer_CurrentNode.Invalidate();
        }

        public class ApplyTemplateDialogResult
        {
            public ValueType TypeT { get; set; } = ValueType.Void;
            public ValueType TypeS { get; set; } = ValueType.Void;
            public int TemplateIndex { get; set; } = -1;

            public ApplyTemplateDialogResult()
            {
            }
        };

        private ApplyTemplateDialogResult result = new ApplyTemplateDialogResult();

        private void Button_OK_Click(object sender, RoutedEventArgs e)
        {
            this.DialogResult = true;
            this.Close();
        }

        private void Button_Cancel_Click(object sender, RoutedEventArgs e)
        {
            this.DialogResult = false;
            this.Close();
        }

        private void Window_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.Key == Key.Enter)
            {
                this.DialogResult = true;
                this.Close();
            }
            else if (e.Key == Key.Escape)
            {
                this.DialogResult = false;
                this.Close();
            }
        }

        private void ComboBox_TypeT_SelectionChanged(object sender, SelectionChangedEventArgs e)
        {
            if (this.ComboBox_TypeT.SelectedIndex >= 0)
            {
                // TODO: 厳密さを欠く
                var temp = ((this.ComboBox_TypeT.SelectedItem as ComboBoxItem)?.Content as string);
                if (temp != null)
                {
                    this.result.TypeT = ValueTypeExt.FromString(temp);
                }
            }
        }

        private void ComboBox_TypeS_SelectionChanged(object sender, SelectionChangedEventArgs e)
        {
            if (this.ComboBox_TypeS.SelectedIndex >= 0)
            {
                // TODO: 厳密さを欠く
                var temp = ((this.ComboBox_TypeS.SelectedItem as ComboBoxItem)?.Content as string);
                if (temp != null)
                {
                    this.result.TypeS = ValueTypeExt.FromString(temp);
                }
            }
        }

        private void ComboBox_Template_SelectionChanged(object sender, SelectionChangedEventArgs e)
        {
            this.result.TemplateIndex = this.ComboBox_Template.SelectedIndex;

            // TODO: きちんとバインドした方がきれいだが後回し
            if (this.ComboBox_Template.SelectedIndex == 1 ||
                this.ComboBox_Template.SelectedIndex == 2 ||
                this.ComboBox_Template.SelectedIndex == 4)
            {
                this.UI_TypeS.Visibility = Visibility.Visible;
            }
            else
            {
                this.UI_TypeS.Visibility = Visibility.Collapsed;
            }
        }

        public void ApplyTemplate(NodeDesc desc)
        {
            // result を使ってテンプレートを適用
            if (this.result.TemplateIndex == -1) { return; }
            if (this.result.TypeT == ValueType.Void) { return; }
            if (this.result.TemplateIndex == 1 || this.result.TemplateIndex == 2 || this.result.TemplateIndex == 4)
            {
                // TODO: もう少しきちんとUIと内容を紐づけた方が良い
                if (this.result.TypeS == ValueType.Void) { return; }
            }

            desc.InputDescs.Clear();
            desc.OutputDescs.Clear();
            switch (this.result.TemplateIndex)
            {
                case 0:
                    // 単項演算
                    {
                        var input = new InputDesc(desc);
                        input.DisplayName = "x";
                        input.ArgTarget = "x";
                        input.Type = this.result.TypeT;
                        desc.AddInputDesc(input);

                        var output = new OutputDesc(desc);
                        output.DisplayName = "value";
                        output.ReturnTarget = "return";
                        output.Type = this.result.TypeT;
                        desc.AddOutputDesc(output);

                        desc.ReturnType = this.result.TypeT;
                    }
                    break;
                case 1:
                    // スカラー積
                    {
                        var input = new InputDesc(desc);
                        input.DisplayName = "x";
                        input.ArgTarget = "x";
                        input.Type = this.result.TypeT;
                        desc.AddInputDesc(input);

                        var input2 = new InputDesc(desc);
                        input2.DisplayName = "param";
                        input2.ArgTarget = "param";
                        input2.Type = this.result.TypeS;
                        desc.AddInputDesc(input2);

                        var output = new OutputDesc(desc);
                        output.DisplayName = "value";
                        output.ReturnTarget = "return";
                        output.Type = this.result.TypeT;
                        desc.AddOutputDesc(output);

                        desc.ReturnType = this.result.TypeT;
                    }
                    break;
                case 2:
                    // 内積
                    {
                        var input = new InputDesc(desc);
                        input.DisplayName = "x";
                        input.ArgTarget = "x";
                        input.Type = this.result.TypeT;
                        desc.AddInputDesc(input);

                        var input2 = new InputDesc(desc);
                        input2.DisplayName = "y";
                        input2.ArgTarget = "y";
                        input2.Type = this.result.TypeT;
                        desc.AddInputDesc(input2);

                        var output = new OutputDesc(desc);
                        output.DisplayName = "value";
                        output.ReturnTarget = "return";
                        output.Type = this.result.TypeS;
                        desc.AddOutputDesc(output);

                        desc.ReturnType = this.result.TypeS;
                    }
                    break;
                case 3:
                    // 外積
                    {
                        var input = new InputDesc(desc);
                        input.DisplayName = "x";
                        input.ArgTarget = "x";
                        input.Type = this.result.TypeT;
                        desc.AddInputDesc(input);

                        var input2 = new InputDesc(desc);
                        input2.DisplayName = "y";
                        input2.ArgTarget = "y";
                        input2.Type = this.result.TypeT;
                        desc.AddInputDesc(input2);

                        var output = new OutputDesc(desc);
                        output.DisplayName = "value";
                        output.ReturnTarget = "return";
                        output.Type = this.result.TypeT;
                        desc.AddOutputDesc(output);

                        desc.ReturnType = this.result.TypeT;
                    }
                    break;
                case 4:
                    // 補間
                    {
                        var input = new InputDesc(desc);
                        input.DisplayName = "x";
                        input.ArgTarget = "x";
                        input.Type = this.result.TypeT;
                        desc.AddInputDesc(input);

                        var input2 = new InputDesc(desc);
                        input2.DisplayName = "y";
                        input2.ArgTarget = "y";
                        input2.Type = this.result.TypeT;
                        desc.AddInputDesc(input2);

                        var input3 = new InputDesc(desc);
                        input3.DisplayName = "param";
                        input3.ArgTarget = "param";
                        input3.Type = this.result.TypeS;
                        desc.AddInputDesc(input3);

                        var output = new OutputDesc(desc);
                        output.DisplayName = "value";
                        output.ReturnTarget = "return";
                        output.Type = this.result.TypeT;
                        desc.AddOutputDesc(output);

                        desc.ReturnType = this.result.TypeT;
                    }
                    break;
                case 5:
                    // 三項演算
                    {
                        var input = new InputDesc(desc);
                        input.DisplayName = "x";
                        input.ArgTarget = "x";
                        input.Type = this.result.TypeT;
                        desc.AddInputDesc(input);

                        var input2 = new InputDesc(desc);
                        input2.DisplayName = "y";
                        input2.ArgTarget = "y";
                        input2.Type = this.result.TypeT;
                        desc.AddInputDesc(input2);

                        var input3 = new InputDesc(desc);
                        input3.DisplayName = "z";
                        input3.ArgTarget = "z";
                        input3.Type = this.result.TypeT;
                        desc.AddInputDesc(input3);

                        var output = new OutputDesc(desc);
                        output.DisplayName = "value";
                        output.ReturnTarget = "return";
                        output.Type = this.result.TypeT;
                        desc.AddOutputDesc(output);

                        desc.ReturnType = this.result.TypeT;
                    }
                    break;
            }

            // シェーダコードをまとめて再生成
            desc.ReGenerateShaderCode();
        }
    }
}
