﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Workflow.Core
{
    /// <summary>
    /// A PlugBase is a WorkflowElement with an index.
    /// </summary>
    /// <typeparam name="T"></typeparam>
    public abstract class PlugBase<T> : WorkflowElement, IEquatable<PlugBase<T>>
    {
        protected PlugBase()
        {
            Index = -1;
        }

        public int Index { get; internal set; }

        private WorkflowItem<T> workflowItem;
        public WorkflowItem<T> WorkflowItem
        {
            get { return workflowItem; }
            internal set
            {
                if (workflowItem == value)
                    return;

                var oldWorkflowItem = workflowItem;
                workflowItem = value;

                OnWorkflowItemChanged(new WorkflowItemChangedEventArgs<T>(oldWorkflowItem, workflowItem));
            }
        }

        protected virtual void OnWorkflowItemChanged(WorkflowItemChangedEventArgs<T> e)
        {
            var handler = WorkflowItemChanged;
            if (handler != null)
                handler(this, e);
        }

        public event EventHandler<WorkflowItemChangedEventArgs<T>> WorkflowItemChanged;

        public bool Equals(PlugBase<T> other)
        {
            return UniquelyIdentifiableExtensions.Equals(this, other);
        }
    }
}
