﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using EffectCombiner.Core.Extensions;
using ShaderGenerator.Core;
using ShaderTyping;

namespace ShaderGenerator.GLSL
{
    public class GlslGenerator : Generator<GlslGenerationContext, FunctionDefinition, PlugValue>
    {
        public GlslGenerator(GlslGenerationContext context, Guid guid)
            : base(context)
        {
            this.guid = guid;
        }

        public override PlugValue[] ProduceOutputs(FunctionDefinition function, PlugValue[] incoming)
        {
            PlugValue[] outputs;

            if (Context.nodeOutputs.TryGetValue(guid, out outputs) == false)
            {
                var variables = incoming
                    .GroupBy(x => x.BaseTarget)
                    .Where(x => x.MoreThanOne() || x.First().BaseTarget != x.First().Target)
                    .ToDictionary(x => x.Key,
                    x => Context.VariableGenerator.GenerateNew(function.Name, x.Key, function.Parameters.First(p => p.Name == x.Key).Type));

                var inputs = incoming
                    .GroupBy(x => x.BaseTarget, x => variables.ContainsKey(x.BaseTarget)
                    ? new PlugValue(x.Type, x.Expression, variables[x.BaseTarget].Name + PlugValue.GetTargetFields(x.Target))
                    : x)
                    .ToArray();

                var outputsList = new List<PlugValue>();
                if (!function.ReturnType.IsVoid)
                {
                    var variable = Context.VariableGenerator.GenerateNew(function.Name, "return", function.ReturnType);
                    outputsList.Add(new PlugValue(variable));
                }
                outputsList.AddRange(function.Parameters
                    .Where(x => x.IsAnOutput)
                    .Select(x => variables.ContainsKey(x.Name)
                        ? new PlugValue(variables[x.Name])
                        : new PlugValue(Context.VariableGenerator.GenerateNew(function.Name, x.Name, x.Type))));

                outputs = outputsList.ToArray();


                Context.AddFunctionCall(guid, new FunctionCall(function, inputs, outputs));
            }

            return outputs;
        }

        private Guid guid;
    }
}
