﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Renderer2D.Core;
using Renderer2D.Core.WinForms;
using WinFormsTestApp.Properties;

namespace WinFormsTestApp
{
    public class RenderSurface : RenderControl
    {
        private readonly RendererDisplayControl parent;

        private IBrush solidRedBrush;
        private IBrush solidBlueBrush;
        private IBrush solidBlackBrush;

        private IBrush linearGradient1Brush;
        private IBrush linearGradient2Brush;
        private IBrush linearGradient3Brush;
        private IBrush linearGradient4Brush;
        private IBrush linearGradient5Brush;
        private IBrush linearGradient6Brush;
        private IBrush linearGradient7Brush;
        private IBrush linearGradientSpectrumBrush;
        private IBrush linearGradientTransparentRedBrush;
        //private IBrush[] radialGradientBrush;

        private IBitmap bitmapTest01;

        public RenderSurface(RendererDisplayControl parent)
        {
            if (parent == null)
                throw new ArgumentNullException("parent");

            this.parent = parent;
        }

        public void InitializeResources()
        {
            try
            {
                bitmapTest01 = Renderer.CreateBitmap(Resources.test01.ToRendererBitmapDefinition());

                solidRedBrush = Renderer.CreateSolidColorBrush(new Renderer2D.Core.Color(255, 0, 0));
                solidBlueBrush = Renderer.CreateSolidColorBrush(new Renderer2D.Core.Color(0, 0, 255));
                solidBlackBrush = Renderer.CreateSolidColorBrush(new Renderer2D.Core.Color(0, 0, 0, 255));

                linearGradient1Brush = Renderer.CreateLinearGradientBrush(
                    new Renderer2D.Core.Point(0.2, 0.2),
                    new Renderer2D.Core.Point(0.8, 0.2),
                    new GradientStop(new Renderer2D.Core.Color(0, 0, 0), 0.0),
                    new GradientStop(new Renderer2D.Core.Color(255, 255, 255), 1.0));
                linearGradient2Brush = Renderer.CreateLinearGradientBrush(
                    new Renderer2D.Core.Point(0.2, 0.2),
                    new Renderer2D.Core.Point(0.8, 0.4),
                    new GradientStop(new Renderer2D.Core.Color(14, 83, 167), 0.0),
                    new GradientStop(new Renderer2D.Core.Color(255, 156, 0), 1.0));
                linearGradient3Brush = Renderer.CreateLinearGradientBrush(
                    new Renderer2D.Core.Point(0.2, 0.2),
                    new Renderer2D.Core.Point(0.8, 0.6),
                    new GradientStop(new Renderer2D.Core.Color(255, 0, 128), 0.0),
                    new GradientStop(new Renderer2D.Core.Color(0, 128, 255), 1.0));
                linearGradient4Brush = Renderer.CreateLinearGradientBrush(
                    new Renderer2D.Core.Point(0.2, 0.2),
                    new Renderer2D.Core.Point(0.8, 0.8),
                    new GradientStop(new Renderer2D.Core.Color(255, 164, 0), 0.0),
                    new GradientStop(new Renderer2D.Core.Color(255, 13, 0), 1.0));
                linearGradient5Brush = Renderer.CreateLinearGradientBrush(
                    new Renderer2D.Core.Point(0.2, 0.2),
                    new Renderer2D.Core.Point(0.6, 0.8),
                    new GradientStop(new Renderer2D.Core.Color(124, 231, 0), 0.0),
                    new GradientStop(new Renderer2D.Core.Color(220, 0, 85), 1.0));
                linearGradient6Brush = Renderer.CreateLinearGradientBrush(
                    new Renderer2D.Core.Point(0.2, 0.2),
                    new Renderer2D.Core.Point(0.4, 0.8),
                    new GradientStop(new Renderer2D.Core.Color(4, 133, 157), 0.0),
                    new GradientStop(new Renderer2D.Core.Color(255, 0, 0), 0.5),
                    new GradientStop(new Renderer2D.Core.Color(255, 182, 0), 1.0));
                linearGradient7Brush = Renderer.CreateLinearGradientBrush(
                    new Renderer2D.Core.Point(0.2, 0.2),
                    new Renderer2D.Core.Point(0.2, 0.8),
                    new GradientStop(new Renderer2D.Core.Color(76, 232, 165), 0.0),
                    new GradientStop(new Renderer2D.Core.Color(87, 157, 230), 0.6),
                    new GradientStop(new Renderer2D.Core.Color(116, 97, 233), 1.0));

                linearGradientSpectrumBrush = Renderer.CreateLinearGradientBrush(
                    new Renderer2D.Core.Point(0.8, 0.1),
                    new Renderer2D.Core.Point(0.2, 0.0),
                    new GradientStop(new Renderer2D.Core.Color(0, 0, 0), 0.0),
                    new GradientStop(new Renderer2D.Core.Color(255, 0, 0), 0.2),
                    new GradientStop(new Renderer2D.Core.Color(100, 0, 100), 0.9),
                    new GradientStop(new Renderer2D.Core.Color(0, 255, 0), 0.5),
                    new GradientStop(new Renderer2D.Core.Color(0, 255, 255), 0.6),
                    new GradientStop(new Renderer2D.Core.Color(255, 255, 0), 0.4),
                    new GradientStop(new Renderer2D.Core.Color(0, 0, 255), 0.8),
                    new GradientStop(new Renderer2D.Core.Color(0, 0, 0), 1.0));

                linearGradientTransparentRedBrush = Renderer.CreateLinearGradientBrush(
                    new Renderer2D.Core.Point(0.0, 0.0),
                    new Renderer2D.Core.Point(1.0, 0.0),
                    new GradientStop(new Renderer2D.Core.Color(255, 0, 0, 0), 0.0),
                    new GradientStop(new Renderer2D.Core.Color(255, 0, 0, 255), 1.0));

                /*
                radialGradientBrush = new IBrush[5];

                radialGradientBrush[0] = Renderer.CreateRadialGradientBrush(
                    new Renderer2D.Core.Point(0.5, 0.5),
                    new Renderer2D.Core.Point(0.0, 0.0),
                    1.0, 1.0,
                    new GradientStop(System.Drawing.Color.PowderBlue.ToRendererColor(), 0.0),
                    new GradientStop(System.Drawing.Color.SteelBlue.ToRendererColor(), 1.0));

                var k = 1;
                var gradientOffsetY = -0.3;
                for (var i1 = 0; i1 < 2; i1++)
                {
                    var gradientOffsetX = -0.3;
                    for (var i2 = 0; i2 < 2; i2++)
                    {
                        radialGradientBrush[k++] = Renderer.CreateRadialGradientBrush(
                            new Renderer2D.Core.Point(0.5, 0.5),
                            new Renderer2D.Core.Point(gradientOffsetX, gradientOffsetY),
                            1.0, 1.0,
                            new GradientStop(System.Drawing.Color.PowderBlue.ToRendererColor(), 0.0),
                            new GradientStop(System.Drawing.Color.SteelBlue.ToRendererColor(), 1.0));
                        gradientOffsetX += 0.6;
                    }
                    gradientOffsetY += 0.6;
                }
                */
            }
            catch (Exception ex)
            {
                parent.AddError(ex);
            }
        }

        protected override void OnRender()
        {
            try
            {
                Renderer.Clear(new Renderer2D.Core.Color(150, 150, 200));
                Renderer.FillRectangle(new Renderer2D.Core.Rectangle(10.0, 80.0, 120.0, 120.0), solidBlueBrush);

                GradientUseTest(linearGradient1Brush, 10, 10, 5, 50);
                GradientUseTest(linearGradient2Brush, 70, 10, 5, 50);
                GradientUseTest(linearGradient3Brush, 130, 10, 5, 50);
                GradientUseTest(linearGradient4Brush, 190, 10, 5, 50);
                GradientUseTest(linearGradient5Brush, 250, 10, 5, 50);
                GradientUseTest(linearGradient6Brush, 310, 10, 5, 50);
                GradientUseTest(linearGradient7Brush, 370, 10, 5, 50);
                GradientUseTest(linearGradientSpectrumBrush, 430, 10, 5, 50);

                Renderer.FillRoundedRectangle(new Renderer2D.Core.Rectangle(300.0, 220.0, 150.0, 80.0), 20.0, 10.0, linearGradient7Brush);
                Renderer.DrawRoundedRectangle(new Renderer2D.Core.Rectangle(300.0, 220.0, 150.0, 80.0), 20.0, 10.0, solidBlackBrush, 3.0, StrokeStyle.Default);
                Renderer.FillRoundedRectangle(new Renderer2D.Core.Rectangle(300.0, 320.0, 150.0, 80.0), 0.0, 10.0, linearGradient7Brush);
                Renderer.DrawRoundedRectangle(new Renderer2D.Core.Rectangle(300.0, 320.0, 150.0, 80.0), 0.0, 10.0, solidBlackBrush, 3.0, StrokeStyle.Default);

                Renderer.DrawEllipse(new Renderer2D.Core.Ellipse(200.0, 150.0, 40.0, 20.0), solidBlackBrush, 2.0);
                Renderer.FillEllipse(new Renderer2D.Core.Ellipse(200.0, 150.0, 30.0, 15.0), linearGradient1Brush);

                Renderer.DrawBezier(
                    new Renderer2D.Core.Point(300.0, 100.0),
                    new Renderer2D.Core.Point(350.0, 100.0),
                    new Renderer2D.Core.Point(350.0, 200.0),
                    new Renderer2D.Core.Point(400.0, 200.0),
                    solidRedBrush, 3.0);

                /*
                for (var i = 0; i < 5; i++)
                {
                    var cx = 60.0 + (i * 110.0);
                    const double cy = 470.0;
                    Renderer.FillEllipse(cx, cy, 50.0, 50.0, radialGradientBrush[i]);
                    Renderer.DrawEllipse(cx, cy, 50.0, 50.0, solidBlackBrush, 1.0, StrokeStyle.Default);
                }
                */

                Renderer.DrawRectangle(new Renderer2D.Core.Rectangle(30.0, 80.0, 100.0, 100.0), linearGradientTransparentRedBrush, 4.0);

                var fancyFont = new Renderer2D.Core.Font("Palatino Linotype", 18.0,
                                                         FontStretch.UltraCondensed, Renderer2D.Core.FontStyle.Italic, FontWeight.Black);

                Renderer.DrawText("Text test efficiency", new TextFormat(fancyFont), new Renderer2D.Core.Point(30, 80), solidBlackBrush);

                var mtx = Matrix.Rotation(-10.0, 256, 256);
                Renderer.Transform = mtx;

                IPoint p = new Renderer2D.Core.Point(50.0, 350.0);
                p = Matrix.TransformPoint(Matrix.Scale(0.5, 0.5), p);

                Renderer.DrawBitmap(bitmapTest01, new Renderer2D.Core.Rectangle(p, new Renderer2D.Core.Size(256.0, 256.0)));

                Renderer.Transform = Matrix.Identity;
            }
            catch (Exception ex)
            {
                parent.AddError(ex);
            }
        }

        private void GradientUseTest(IBrush brush, double x, double y, double small, double big)
        {
            Renderer.FillRectangle(new Renderer2D.Core.Rectangle(x, y, big, big), brush);
            Renderer.FillRectangle(new Renderer2D.Core.Rectangle(x + big, y, small, big), brush);
            Renderer.FillRectangle(new Renderer2D.Core.Rectangle(x, y + big, big, small), brush);
        }

        protected override void OnTerminate()
        {
            base.OnTerminate();

            try
            {
                solidRedBrush.Dispose();
                solidBlueBrush.Dispose();
                solidBlackBrush.Dispose();

                linearGradient1Brush.Dispose();
                linearGradient2Brush.Dispose();
                linearGradient3Brush.Dispose();
                linearGradient4Brush.Dispose();
                linearGradient5Brush.Dispose();
                linearGradient6Brush.Dispose();
                linearGradient7Brush.Dispose();
                linearGradientTransparentRedBrush.Dispose();
                linearGradientSpectrumBrush.Dispose();
                /*
                for (var i = 0; i < 5; i++)
                    radialGradientBrush[i].Dispose();
                */
            }
            catch (Exception ex)
            {
                var message = string.Format("[{0}] {1}: {2}", Renderer.GetType().FullName, ex.GetType().FullName, ex.Message);
                Globals.ReportManager.AddErrorReport(new ErrorReport(message, ReportCategory.RendererComposition));
            }
        }
    }
}
