﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Text;

namespace Renderer2D.Core
{
    public enum CapStyle
    {
        /// <summary>
        /// A cap that does not extend past the last point of the line.
        /// Comparable to cap used for objects other than lines.
        /// </summary>
        Flat,
        /// <summary>
        /// Half of a square that has a length equal to the line thickness.
        /// </summary>
        Square,
        /// <summary>
        /// A semicircle that has a diameter equal to the line thickness.
        /// </summary>
        Round,
        /// <summary>
        /// An isosceles right triangle whose hypotenuse is equal in length to the thickness of the line.
        /// </summary>
        Triangle,
    }

    public enum DashStyle
    {
        /// <summary>
        /// A solid line with no breaks.
        /// </summary>
        Solid,
        /// <summary>
        /// A dash followed by a gap of equal length.
        /// The dash and the gap are each twice as long as the stroke thickness.
        /// </summary>
        Dash,
        /// <summary>
        /// A dot followed by a longer gap.
        /// </summary>
        Dot,
        /// <summary>
        /// A dash, followed by a gap, followed by a dot, followed by another gap.
        /// </summary>
        DashDot,
        /// <summary>
        /// A dash, followed by a gap, followed by a dot, followed by another gap, followed by another dot, followed by another gap.
        /// </summary>
        DashDotDot,
        /// <summary>
        /// The dash pattern is specified by an array of floating-point values.
        /// </summary>
        Custom,
    }

    public enum LineJoin
    {
        /// <summary>
        /// Regular angular vertices.
        /// </summary>
        Miter,
        /// <summary>
        /// Beveled vertices.
        /// </summary>
        Bevel,
        /// <summary>
        /// Rounded vertices.
        /// </summary>
        Round,
        /// <summary>
        /// Regular angular vertices unless the join would extend beyond the miter limit; otherwise, beveled vertices.
        /// </summary>
        MiterOrBevel,
    }

    public interface IStrokeStyle
    {
        CapStyle DashCap { get; }
        double[] Dashes { get; }
        double DashOffset { get; }
        DashStyle DashStyle { get; }
        CapStyle StartCap { get; }
        CapStyle EndCap { get; }
        LineJoin LineJoin { get; }
        double MiterLimit { get; }
    }

    public class StrokeStyle : IStrokeStyle
    {
        public static readonly StrokeStyle Default = new StrokeStyle();

        public CapStyle DashCap { get; set; }
        public double[] Dashes { get; set; }
        public double DashOffset { get; set; }
        public DashStyle DashStyle { get; set; }
        public CapStyle StartCap { get; set; }
        public CapStyle EndCap { get; set; }
        public LineJoin LineJoin { get; set; }
        public double MiterLimit { get; set; }
    }
}
