﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using OperationManager.Core;

namespace TestProject1
{
    public class DummyOperation : Operation
    {
        public int UndoCount { get; private set; }
        public int RedoCount { get; private set; }

        public DummyOperation(string displayName)
            : base(displayName)
        {
        }

        public override void Rollback()
        {
            UndoCount++;
        }

        public override void Execute()
        {
            RedoCount++;
        }

        public override string ToString()
        {
            return DisplayName;
        }
    }

    public class DummyOperationManager : OperationManager<DummyOperation>
    {
        public DummyOperationManager()
        {
        }

        public DummyOperationManager(int maxCapacity)
            : base(maxCapacity)
        {
        }

        public DummyOperationManager(IEnumerable<DummyOperation> originalActionItems)
            : base(originalActionItems)
        {
        }

        public DummyOperationManager(int maxCapacity, IEnumerable<DummyOperation> originalActionItems)
            : base(maxCapacity, originalActionItems)
        {
        }

        public new int Index
        {
            get { return base.Index; }
        }
    }
}
