﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Text;
using System.Collections.Generic;
using System.Linq;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace TestProject1
{
    [TestClass]
    public class MarkerTests
    {
        [TestMethod]
        public void MarkerTest1()
        {
            var stack = new DummyOperationManager();

            var marker1 = stack.AcquireCurrentGuid();
            if (marker1 != Guid.Empty)
                throw new Exception();
        }

        [TestMethod]
        public void MarkerTest2()
        {
            var stack = new DummyOperationManager();

            stack.Undo();

            var marker1 = stack.AcquireCurrentGuid();
            if (marker1 != Guid.Empty)
                throw new Exception();
        }

        [TestMethod]
        public void MarkerTest3()
        {
            var stack = new DummyOperationManager();

            stack.Undo();
            stack.Undo();

            var a = new DummyOperation("a");
            stack.Add(a);

            var marker1 = stack.AcquireCurrentGuid();
            if (marker1 != a.Identifier)
                throw new Exception();
        }

        [TestMethod]
        public void MarkerTest4()
        {
            var stack = new DummyOperationManager();

            var a = new DummyOperation("a");
            stack.Add(a);

            stack.Undo();
            stack.Undo();

            stack.Redo();

            var marker1 = stack.AcquireCurrentGuid();
            if (marker1 != a.Identifier)
                throw new Exception();
        }

        [TestMethod]
        public void MarkerTest5()
        {
            var stack = new DummyOperationManager();

            var a = new DummyOperation("a");
            stack.Add(a);

            stack.Undo();
            stack.Undo();

            stack.Redo();

            stack.Undo();

            var marker1 = stack.AcquireCurrentGuid();
            if (marker1 != Guid.Empty)
                throw new Exception();
        }

        [TestMethod]
        public void MarkerTest6()
        {
            var stack = new DummyOperationManager();

            var a1 = new DummyOperation("1");
            var a2 = new DummyOperation("2");

            var m1 = stack.AcquireCurrentGuid();

            stack.Add(a1);
            var m2 = stack.AcquireCurrentGuid();

            stack.Add(a2);
            var m3 = stack.AcquireCurrentGuid();

            stack.Undo();
            var m4 = stack.AcquireCurrentGuid();

            if (m1 == m2)
                throw new Exception();

            if (m2 == m3)
                throw new Exception();

            if (m1 == m3)
                throw new Exception();

            if (m4 == m1)
                throw new Exception();

            if (m4 != m2)
                throw new Exception();

            if (m4 == m3)
                throw new Exception();
        }

        [TestMethod]
        public void MarkerTest7()
        {
            var stack = new DummyOperationManager();

            var a1 = new DummyOperation("1");
            var a2 = new DummyOperation("2");

            stack.Add(a1);
            var m2 = stack.AcquireCurrentGuid();

            stack.Add(a2);
            var m3 = stack.AcquireCurrentGuid();

            stack.Undo();

            var m4 = stack.AcquireCurrentGuid();

            stack.Redo();

            if (stack.IsCurrentGuid(m3) == false)
                throw new Exception();

            stack.Undo();

            if (stack.IsCurrentGuid(m2) == false)
                throw new Exception();
            if (stack.IsCurrentGuid(m4) == false)
                throw new Exception();
        }
    }
}
