﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;

namespace EnvironmentReporting
{
    public class StreamContextInformation : ContextInformation
    {
        public StreamContextInformation(string name, Stream stream)
        {
            if (string.IsNullOrWhiteSpace(name)) throw new ArgumentException("name");
            if (stream == null) throw new ArgumentNullException();
            Name = name;
            Stream = stream;
        }

        public string Name { get; private set; }
        public Stream Stream { get; private set; }

        public override string ToString()
        {
            return Name.ToString();
        }
    }
}
