﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using EnvironmentReporting;

namespace EnvironmentInformationProvider
{
    class PowerInformationProvider : IInformationProvider
    {
        public string InformationDescription { get { return "Power"; } }

        public ContextInformation GetInformation()
        {
            var powerInfo = new ContextInformationContainer();

            var powerStatus = SystemInformation.PowerStatus;

            powerInfo.Add("Power line status", new StringContextInformation(powerStatus.PowerLineStatus.ToString()));
            powerInfo.Add("Battery charge status", new StringContextInformation(powerStatus.BatteryChargeStatus.ToString()));
            powerInfo.Add("Battery full life-time (s)", new DecimalContextInformation(powerStatus.BatteryFullLifetime));
            powerInfo.Add("Remaining battery charge (%)", new DecimalContextInformation(new decimal(100.0f * powerStatus.BatteryLifePercent)));
            powerInfo.Add("Remaining battery charge (s)", new DecimalContextInformation(powerStatus.BatteryLifeRemaining));

            return powerInfo;
        }
    }
}
