﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using EnvironmentReporting;

namespace EnvironmentInformationProvider
{
    public class EnvironmentVariablesInformationProvider : IInformationProvider
    {
        public string InformationDescription { get { return "Environment variables"; } }

        public ContextInformation GetInformation()
        {
            var envVarInfo = new ContextInformationContainer();

            foreach (string envVarName in Environment.GetEnvironmentVariables().Keys)
            {
                envVarInfo.Add(envVarName, new StringContextInformation(Environment.GetEnvironmentVariable(envVarName)));
            }

            return envVarInfo;
        }
    }
}
