﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace EffectDefinitions
{
    /// <summary>
    /// uniform 変数情報です。
    /// </summary>
    public class UniformDefinition
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="name">変数名</param>
        /// <param name="displayname">表示名</param>
        /// <param name="type">uniform 変数の型名</param>
        /// <param name="extension">ファイルの拡張子（type が file のときに使用）</param>
        public UniformDefinition(string name, string displayname, string type, string extension)
        {
            this.Name = name;
            this.Displayname = displayname;
            this.Type = type;
            this.Extension = extension;
        }

        /// <summary>
        /// uniform 変数名を取得します。
        /// </summary>
        public string Name { get; private set; }

        /// <summary>
        /// 表示名を取得します。
        /// </summary>
        public string Displayname { get; private set; }

        /// <summary>
        /// uniform 変数の型名を取得します。
        /// </summary>
        public string Type { get; private set; }

        /// <summary>
        /// ファイルの拡張子を取得します。
        /// Type が "file" のときに使用します。
        /// </summary>
        public string Extension { get; private set; }
    }
}
