﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;

namespace EffectDefinitions
{
    /// <summary>
    /// ブロックのプレビュー情報です。
    /// </summary>
    public class PreviewDefinition
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public PreviewDefinition()
        {
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="enabled">プレビューが有効かどうか</param>
        /// <param name="location">配置位置</param>
        /// <param name="width">プレビュー表示領域の横幅</param>
        /// <param name="height">プレビュー表示領域の縦幅</param>
        public PreviewDefinition(string enabled, string location, string width, string height)
        {
            // 有効状態をパース
            {
                bool enabledValue;
                bool.TryParse(enabled, out enabledValue);

                this.IsEnabled = enabledValue;
            }

            // 配置位置をパース
            if (Enum.IsDefined(typeof(LocationType), location) == false)
            {
                this.Location = LocationType.Auto;
            }

            // プレビュー画像の横幅と縦幅をパース
            {
                bool resParse;
                double widthValue, heightValue;

                resParse = double.TryParse(width, out widthValue);
                this.Width = resParse ? widthValue : 64.0;

                resParse = double.TryParse(height, out heightValue);
                this.Height = resParse ? heightValue : 64.0;
            }
        }

        /// <summary>
        /// プレビューの配置位置です。
        /// </summary>
        public enum LocationType
        {
            /// <summary>
            /// Plug領域の高さが低いほうに画像を配置します。
            /// </summary>
            Auto
        }

        /// <summary>
        /// プレビューが有効かどうか取得します。
        /// </summary>
        public bool IsEnabled { get; set; } = false;

        /// <summary>
        /// 配置位置を取得します。
        /// </summary>
        public LocationType Location { get; private set; } = LocationType.Auto;

        /// <summary>
        /// プレビューの横幅を取得します。
        /// </summary>
        public double Width { get; private set; } = 64.0;

        /// <summary>
        /// プレビューの縦幅を取得します。
        /// </summary>
        public double Height { get; private set; } = 64.0;
    }
}
