﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;

namespace EffectDefinitions
{
    /// <summary>
    /// Definition of a shader language function parameter, with sources of all its elements.
    /// </summary>
    public class ParameterDefinitionWithSource : ParameterDefinition
    {
        public ParameterDefinitionWithSource(DefinitionLocation source,
            DefinitionLocation nameSource, string name,
            DefinitionLocation typeSource, ShaderTypeDefinition type,
            ShaderTyping.ParameterDirection direction,
            DefinitionLocation usageSource, string usage,
            DefinitionLocation descriptionSource, string description)
            : base(source, name, type, direction, usage, description)
        {
            NameSource = nameSource;
            TypeSource = typeSource;
            UsageSource = usageSource;
            DescriptionSource = descriptionSource;
        }

        public DefinitionLocation NameSource { get; private set; }
        public DefinitionLocation TypeSource { get; private set; }
        public DefinitionLocation UsageSource { get; private set; }
        public DefinitionLocation DescriptionSource { get; private set; }
    }
}
