﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace EffectDefinitions
{
    /// <summary>
    /// Location a definition was read from: URI, line number and such.
    /// </summary>
    public class DefinitionLocation
    {
        public DefinitionLocation(Uri uri)
        {
            Uri = uri;
            HasLineInformation = false;
            LineNumber = 0;
            LinePosition = 0;
            Length = 0;
        }

        public DefinitionLocation(Uri uri, bool hasLineInformation, int lineNumber, int linePosition, int length)
        {
            Uri = uri;
            HasLineInformation = hasLineInformation;
            LineNumber = lineNumber;
            LinePosition = linePosition;
            Length = length;
        }

        public Uri Uri { get; private set; }
        public bool HasLineInformation { get; private set; }
        public int LineNumber { get; private set; }
        public int LinePosition { get; private set; }
        public int Length { get; private set; }

        public override string ToString()
        {
            return string.Format("{0}:({1},{2})", Uri, LineNumber, LinePosition);
        }
    }
}
