﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using EffectCombiner.Primitives.Generation;
using EffectDefinitions;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace EffectCombinerUnitTests
{
    [TestClass]
    public class RegularEffectBlockElementTest
    {
        [TestMethod]
        public void NoPlugConstructorTest()
        {
            var inputPlugs = new Plug[] { };
            var outputPlugs = new Plug[] { };

            RegularEffectBlockElement blockElement = null;
            try
            {
                blockElement = Utility.CreateDummyBlock(inputPlugs, outputPlugs);
            }
            catch
            {
                return;
            }
            if (blockElement != null)
                throw new Exception("RegularEffectBlockElement was expected to fail (no plug).");
        }

        [TestMethod]
        public void VariousPlugsConstructorTest()
        {
            var inputPlugs = new List<Plug>();
            for (int i = 0; i < 50; ++i)
            {
                var outputPlugs = new List<Plug>();
                for (int j = 0; j < 50; ++j)
                {
                    if (i != 0 || j != 0)
                    {
                        var blockElement = Utility.CreateDummyBlock(inputPlugs.ToArray(), outputPlugs.ToArray());
                        if (blockElement == null)
                            throw new Exception(string.Format("RegularEffectBlockElement failed with {0} input plugs and {1} output plugs.", i, j));
                    }

                    outputPlugs.Add(Utility.CreateInputPlug("bar" + i, "vec4"));
                }
                inputPlugs.Add(Utility.CreateInputPlug("foo" + i, "vec4"));
            }
        }

        [TestMethod]
        public void NullInputPlugConstructorTest()
        {
            var inputPlug1 = Utility.CreateInputPlug("foo", "int");
            var inputPlug2 = Utility.CreateInputPlug("bar", "float");

            RegularEffectBlockElement blockElement = null;
            try
            {
                blockElement = Utility.CreateDummyInputBlock(inputPlug1, inputPlug2, null);
            }
            catch
            {
                return;
            }
            if (blockElement != null)
                throw new Exception("RegularEffectBlockElement was expected to fail (null plug).");
        }

        [TestMethod]
        public void NullOutputPlugConstructorTest()
        {
            var outputPlug1 = Utility.CreateOutputPlug("foo", "int");
            var outputPlug2 = Utility.CreateOutputPlug("bar", "float");

            RegularEffectBlockElement blockElement = null;
            try
            {
                blockElement = Utility.CreateDummyOutputBlock(outputPlug1, outputPlug2, null);
            }
            catch
            {
                return;
            }
            if (blockElement != null)
                throw new Exception("RegularEffectBlockElement was expected to fail (null plug).");
        }

        [TestMethod]
        public void InputPlugOnOutputConstructorTest()
        {
            var inputPlug1 = Utility.CreateInputPlug("foo", "int");
            var inputPlug2 = Utility.CreateInputPlug("bar", "float");
            var inputPlug3 = Utility.CreateInputPlug("baz", "vec4");

            RegularEffectBlockElement blockElement = null;
            try
            {
                blockElement = Utility.CreateDummyOutputBlock(inputPlug1, inputPlug2, inputPlug3);
            }
            catch
            {
                return;
            }
            if (blockElement != null)
                throw new Exception("RegularEffectBlockElement was expected to fail (input plug instead of output).");
        }

        [TestMethod]
        public void OutputPlugOnInputConstructorTest()
        {
            var outputPlug1 = Utility.CreateOutputPlug("foo", "int");
            var outputPlug2 = Utility.CreateOutputPlug("bar", "float");
            var outputPlug3 = Utility.CreateOutputPlug("baz", "vec4");

            RegularEffectBlockElement blockElement = null;
            try
            {
                blockElement = Utility.CreateDummyInputBlock(outputPlug1, outputPlug2, outputPlug3);
            }
            catch
            {
                return;
            }
            if (blockElement != null)
                throw new Exception("RegularEffectBlockElement was expected to fail (output plug instead of input).");
        }
    }
}
